/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.builder.Builder;
import io.continual.iam.identity.Identity;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.util.naming.Path;
import java.util.HashMap;
import java.util.TreeSet;

public class BasicModelRequestContext
implements ModelRequestContext {
    private final Identity fUser;
    private final ModelRequestContext.CacheControl fCacheControl;
    private final Path fMountPoint;
    private final ModelSchemaRegistry fSchemaReg;
    private final ModelNotificationService fNotificationService;
    private final HashMap<Path, ModelObject> fObjects;
    private final HashMap<String, Object> fRawData;
    private final TreeSet<Path> fKnownNotToExist;

    public BasicModelRequestContext(BasicModelRequestContextBuilder mrcBuilder) throws Builder.BuildFailure {
        this.fUser = mrcBuilder.fUser;
        this.fCacheControl = ModelRequestContext.CacheControl.READ_AND_WRITE;
        this.fMountPoint = mrcBuilder.fMountPoint;
        this.fObjects = new HashMap();
        this.fKnownNotToExist = new TreeSet();
        this.fRawData = new HashMap();
        this.fSchemaReg = mrcBuilder.fSchemaReg;
        this.fNotificationService = mrcBuilder.fNotificationSvc;
    }

    @Override
    public Identity getOperator() {
        return this.fUser;
    }

    @Override
    public ModelRequestContext.CacheControl getCacheControl() {
        return this.fCacheControl;
    }

    @Override
    public ModelObject get(Path key) {
        return this.fObjects.get(key);
    }

    @Override
    public void put(Path key, ModelObject o) {
        this.fObjects.put(key, o);
        this.fKnownNotToExist.remove(key);
    }

    @Override
    public void remove(Path objectPath) {
        this.fObjects.remove(objectPath);
        this.fKnownNotToExist.add(objectPath);
    }

    @Override
    public Object getRawData(String key) {
        return this.fRawData.get(key);
    }

    @Override
    public <T> T getRawData(String key, Class<T> c) {
        Object data = this.getRawData(key);
        if (data == null || !c.isInstance(data)) {
            return null;
        }
        try {
            return c.cast(data);
        }
        catch (ClassCastException x) {
            return null;
        }
    }

    @Override
    public void putRawData(String key, Object value) {
        this.fRawData.put(key, value);
    }

    @Override
    public void doesNotExist(Path key) {
        this.fKnownNotToExist.add(key);
        this.fObjects.remove(key);
    }

    @Override
    public boolean knownToNotExist(Path key) {
        return this.fKnownNotToExist.contains(key);
    }

    @Override
    public Path getMountPoint() {
        return this.fMountPoint;
    }

    @Override
    public ModelSchemaRegistry getSchemaRegistry() {
        return this.fSchemaReg;
    }

    @Override
    public ModelNotificationService getNotificationService() {
        return this.fNotificationService;
    }
}

