/*
 * Decompiled with CFR 0.152.
 */
package io.continual.metrics;

import io.continual.builder.Builder;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.ReporterBuilder;
import io.continual.metrics.impl.StdMetricsCatalog;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.shaded.com.codahale.metrics.Counter;
import io.continual.shaded.com.codahale.metrics.Gauge;
import io.continual.shaded.com.codahale.metrics.Histogram;
import io.continual.shaded.com.codahale.metrics.Meter;
import io.continual.shaded.com.codahale.metrics.Metric;
import io.continual.shaded.com.codahale.metrics.MetricRegistry;
import io.continual.shaded.com.codahale.metrics.ScheduledReporter;
import io.continual.shaded.com.codahale.metrics.Snapshot;
import io.continual.shaded.com.codahale.metrics.Timer;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetricsService
extends SimpleService {
    private final MetricRegistry fReg = new MetricRegistry();
    private final LinkedList<ScheduledReporter> fReporters = new LinkedList();

    public MetricsService(ServiceContainer sc, JSONObject config) throws Builder.BuildFailure {
        JsonVisitor.forEachElement((JSONArray)config.optJSONArray("reporters"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<JSONObject, Builder.BuildFailure>(){

            public boolean visit(JSONObject reporterData) throws JSONException, Builder.BuildFailure {
                if (reporterData.optBoolean("enabled", true)) {
                    Builder.withBaseClass(ReporterBuilder.class).withClassNameInData().usingData(reporterData).providingContext((Object)MetricsService.this).build();
                    MetricsService.this.fReporters.add((ScheduledReporter)Builder.fromJson(ScheduledReporter.class, (JSONObject)reporterData));
                }
                return true;
            }
        });
    }

    @Deprecated
    public MetricRegistry getRegistry() {
        return this.fReg;
    }

    public MetricsCatalog getCatalog(String string) {
        return this.getCatalog(Path.getRootPath().makeChildItem(Name.fromString((String)string)));
    }

    public MetricsCatalog getCatalog(Path path) {
        return new StdMetricsCatalog(this.fReg, path);
    }

    protected void onStartRequested() throws Service.FailedToStart {
        super.onStartRequested();
        for (ScheduledReporter r : this.fReporters) {
            r.start(1L, TimeUnit.MINUTES);
        }
    }

    protected void onStopRequested() {
        for (ScheduledReporter r : this.fReporters) {
            r.stop();
        }
        super.onStopRequested();
    }

    public JSONObject toJson() {
        return MetricsService.toJson(this.fReg);
    }

    public static JSONObject toJson(MetricRegistry reg) {
        JSONObject result = new JSONObject();
        for (Map.Entry<String, Metric> e : reg.getMetrics().entrySet()) {
            String key = e.getKey();
            String[] parts = key.split("\\.");
            JSONObject target = result;
            for (int i = 0; i < parts.length - 1; ++i) {
                Object tmp = target.opt(parts[i]);
                if (tmp == null) {
                    tmp = new JSONObject();
                    target.put(parts[i], tmp);
                } else if (!(tmp instanceof JSONObject)) {
                    throw new IllegalStateException("Overlapping metric names at " + key);
                }
                target = (JSONObject)tmp;
            }
            target.put(parts[parts.length - 1], (Object)MetricsService.toJson(e.getValue()));
        }
        return result;
    }

    public static JSONObject toJson(Metric m) {
        JSONObject result = new JSONObject();
        if (m instanceof Counter) {
            Counter mm = (Counter)m;
            result.put("count", mm.getCount());
        } else if (m instanceof Gauge) {
            Gauge mm = (Gauge)m;
            result.put("value", (Object)mm.getValue().toString());
        } else if (m instanceof Meter) {
            Meter mm = (Meter)m;
            result.put("count", mm.getCount()).put("rateMean", mm.getMeanRate()).put("rate1Min", mm.getOneMinuteRate()).put("rate5Min", mm.getFiveMinuteRate()).put("rate15Min", mm.getFifteenMinuteRate());
        } else if (m instanceof Timer) {
            Timer mm = (Timer)m;
            result.put("count", mm.getCount()).put("rateMean", mm.getMeanRate()).put("rate1Min", mm.getOneMinuteRate()).put("rate5Min", mm.getFiveMinuteRate()).put("rate15Min", mm.getFifteenMinuteRate()).put("snapshot", (Object)MetricsService.renderSnapshot(mm.getSnapshot()));
        } else if (m instanceof Histogram) {
            Histogram mm = (Histogram)m;
            result.put("count", mm.getCount()).put("snapshot", (Object)MetricsService.renderSnapshot(mm.getSnapshot()));
        } else {
            result.put("value", (Object)("unknown metric type " + m.getClass().getCanonicalName()));
        }
        return result;
    }

    private static JSONObject renderSnapshot(Snapshot s) {
        return new JSONObject().put("min", s.getMin()).put("max", s.getMax()).put("mean", s.getMean()).put("median", s.getMedian()).put("stddev", s.getStdDev()).put("pct75", s.get75thPercentile()).put("pct95", s.get95thPercentile()).put("pct98", s.get98thPercentile()).put("pct99", s.get99thPercentile()).put("pct999", s.get999thPercentile());
    }
}

