/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.core;

import io.continual.builder.Builder;
import io.continual.iam.identity.Identity;
import io.continual.services.Service;
import io.continual.services.model.core.ModelCapabilities;
import io.continual.services.model.core.ModelIdentification;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelPathList;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.core.ModelUpdater;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelSchemaViolationException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.core.updaters.DataOverwrite;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.naming.Path;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;

public interface Model
extends ModelIdentification,
ModelCapabilities,
Closeable,
Service {
    public ModelRequestContextBuilder getRequestContextBuilder();

    public boolean exists(ModelRequestContext var1, Path var2) throws ModelServiceException, ModelRequestException;

    public ModelPathList listObjectsStartingWith(ModelRequestContext var1, Path var2) throws ModelServiceException, ModelRequestException;

    public ModelQuery startQuery() throws ModelRequestException;

    public ModelObject load(ModelRequestContext var1, Path var2) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException;

    default public void store(ModelRequestContext context, Path objectPath, String jsonData) throws ModelRequestException, ModelSchemaViolationException, ModelServiceException {
        this.store(context, objectPath, new DataOverwrite(JsonUtil.readJsonObject((String)jsonData)));
    }

    default public void store(ModelRequestContext context, Path objectPath, JSONObject jsonData) throws ModelRequestException, ModelSchemaViolationException, ModelServiceException {
        this.store(context, objectPath, new DataOverwrite(jsonData));
    }

    public void store(ModelRequestContext var1, Path var2, ModelUpdater ... var3) throws ModelRequestException, ModelSchemaViolationException, ModelServiceException;

    public boolean remove(ModelRequestContext var1, Path var2) throws ModelServiceException, ModelRequestException;

    public void relate(ModelRequestContext var1, ModelRelation var2) throws ModelServiceException, ModelRequestException;

    public boolean unrelate(ModelRequestContext var1, ModelRelation var2) throws ModelServiceException, ModelRequestException;

    default public List<ModelRelation> getRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        result.addAll(this.getInboundRelations(context, forObject));
        result.addAll(this.getOutboundRelations(context, forObject));
        return result;
    }

    default public List<ModelRelation> getInboundRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        return this.getInboundRelationsNamed(context, forObject, null);
    }

    default public List<ModelRelation> getOutboundRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        return this.getOutboundRelationsNamed(context, forObject, null);
    }

    public List<ModelRelation> getInboundRelationsNamed(ModelRequestContext var1, Path var2, String var3) throws ModelServiceException, ModelRequestException;

    public List<ModelRelation> getOutboundRelationsNamed(ModelRequestContext var1, Path var2, String var3) throws ModelServiceException, ModelRequestException;

    public static interface ModelRequestContextBuilder {
        public ModelRequestContextBuilder forUser(Identity var1);

        public ModelRequestContextBuilder mountedAt(Path var1);

        public ModelRequestContextBuilder withSchemasFrom(ModelSchemaRegistry var1);

        public ModelRequestContextBuilder withNotificationsTo(ModelNotificationService var1);

        public ModelRequestContext build() throws Builder.BuildFailure;
    }
}

