/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.delegator;

import io.continual.builder.Builder;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelPathList;
import io.continual.services.model.core.ModelQuery;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelUpdater;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.common.BasicModelRequestContextBuilder;
import io.continual.services.model.impl.delegator.ModelMount;
import io.continual.services.model.impl.json.CommonJsonDbObjectContainer;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingModel
extends SimpleService
implements Model {
    private final String fAcctId;
    private final String fModelId;
    private final LinkedList<ModelMount> fUserMountTable;
    private static final Logger log = LoggerFactory.getLogger(DelegatingModel.class);

    public DelegatingModel(ServiceContainer sc, JSONObject config) {
        this(config.getString("acctId"), config.getString("modelId"));
    }

    public DelegatingModel(String acctId, String modelId) {
        this.fAcctId = acctId;
        this.fModelId = modelId;
        this.fUserMountTable = new LinkedList();
    }

    public DelegatingModel mount(ModelMount mm) {
        this.fUserMountTable.add(mm);
        return this;
    }

    @Override
    public String getAcctId() {
        return this.fAcctId;
    }

    @Override
    public String getId() {
        return this.fModelId;
    }

    @Override
    public long getMaxPathLength() {
        return 0L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 0L;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        for (ModelMount mm : this.fUserMountTable) {
            Model m = mm.getModel();
            log.info("Closing " + m.getAcctId() + "/" + m.getId());
            m.close();
        }
    }

    @Override
    public Model.ModelRequestContextBuilder getRequestContextBuilder() {
        return new BasicModelRequestContextBuilder();
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        try {
            ModelMount mm = this.getModelForPath(objectPath);
            if (mm.getModel() == this) {
                for (ModelMount um : this.fUserMountTable) {
                    Path mp = um.getMountPoint();
                    if (!mp.startsWith(objectPath)) continue;
                    return true;
                }
                return false;
            }
            return mm.getModel().exists(context, mm.getPathWithinModel(objectPath));
        }
        catch (ModelRequestException e) {
            return false;
        }
    }

    @Override
    public ModelPathList listObjectsStartingWith(ModelRequestContext context, Path prefix) throws ModelServiceException, ModelRequestException {
        ModelMount mm = this.getModelForPath(prefix);
        if (mm.getModel() == this) {
            LinkedList<Path> result = new LinkedList<Path>();
            for (ModelMount um : this.fUserMountTable) {
                Path mp = um.getMountPoint();
                if (!mp.startsWith(prefix)) continue;
                Path childPart = mp.makePathWithinParent(prefix);
                result.add(Path.getRootPath().makeChildItem(childPart.getSegments()[0]));
            }
            return ModelPathList.wrap(result);
        }
        return mm.getModel().listObjectsStartingWith(context, mm.getPathWithinModel(prefix));
    }

    @Override
    public ModelQuery startQuery() throws ModelRequestException {
        return null;
    }

    @Override
    public ModelObject load(ModelRequestContext context, Path objectPath) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        ModelMount mm = this.getModelForPath(objectPath);
        if (mm.getModel() == this) {
            LinkedList<Path> result = new LinkedList<Path>();
            for (ModelMount um : this.fUserMountTable) {
                Path mp = um.getMountPoint();
                if (!mp.startsWith(objectPath)) continue;
                Path childPart = mp.makePathWithinParent(objectPath);
                result.add(Path.getRootPath().makeChildItem(childPart.getSegments()[0]));
            }
            return CommonJsonDbObjectContainer.createObjectContainer(objectPath.toString(), result);
        }
        return mm.getModel().load(context, mm.getPathWithinModel(objectPath));
    }

    @Override
    public void store(ModelRequestContext context, Path objectPath, ModelUpdater ... updates) throws ModelRequestException, ModelServiceException {
        ModelMount mm = this.getModelForPath(objectPath);
        if (mm.getModel() == this) {
            throw new ModelRequestException("Cannot store here.");
        }
        mm.getModel().store(context, mm.getPathWithinModel(objectPath), updates);
    }

    @Override
    public boolean remove(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        ModelMount mm = this.getModelForPath(objectPath);
        if (mm.getModel() == this) {
            throw new ModelRequestException("Cannot remove here.");
        }
        return mm.getModel().remove(context, mm.getPathWithinModel(objectPath));
    }

    @Override
    public void relate(ModelRequestContext context, final ModelRelation mr) throws ModelServiceException, ModelRequestException {
        Path to;
        ModelMount mmTo;
        final Path from = mr.getFrom();
        final ModelMount mmFrom = this.getModelForPath(from);
        if (mmFrom == (mmTo = this.getModelForPath(to = mr.getTo()))) {
            mmFrom.getModel().relate(context, new ModelRelation(){

                @Override
                public Path getFrom() {
                    return mmFrom.getPathWithinModel(from);
                }

                @Override
                public Path getTo() {
                    return mmTo.getPathWithinModel(to);
                }

                @Override
                public String getName() {
                    return mr.getName();
                }
            });
        }
    }

    @Override
    public boolean unrelate(ModelRequestContext context, final ModelRelation reln) throws ModelServiceException, ModelRequestException {
        Path to;
        ModelMount mmTo;
        final Path from = reln.getFrom();
        final ModelMount mmFrom = this.getModelForPath(from);
        if (mmFrom == (mmTo = this.getModelForPath(to = reln.getTo()))) {
            return mmFrom.getModel().unrelate(context, new ModelRelation(){

                @Override
                public Path getFrom() {
                    return mmFrom.getPathWithinModel(from);
                }

                @Override
                public Path getTo() {
                    return mmTo.getPathWithinModel(to);
                }

                @Override
                public String getName() {
                    return reln.getName();
                }
            });
        }
        return false;
    }

    @Override
    public List<ModelRelation> getInboundRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        ModelMount mm = this.getModelForPath(forObject);
        try {
            ModelRequestContext mrc = mm.getModel().getRequestContextBuilder().forUser(context.getOperator()).build();
            for (ModelRelation mrInternal : mm.getModel().getInboundRelations(mrc, mm.getPathWithinModel(forObject))) {
                result.add(new ToGlobalMapper(mm, mrInternal));
            }
        }
        catch (Builder.BuildFailure e) {
            throw new ModelServiceException(e);
        }
        return result;
    }

    @Override
    public List<ModelRelation> getOutboundRelations(ModelRequestContext context, Path forObject) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        ModelMount mm = this.getModelForPath(forObject);
        try {
            ModelRequestContext mrc = mm.getModel().getRequestContextBuilder().forUser(context.getOperator()).build();
            for (ModelRelation mrInternal : mm.getModel().getOutboundRelations(mrc, mm.getPathWithinModel(forObject))) {
                result.add(new ToGlobalMapper(mm, mrInternal));
            }
        }
        catch (Builder.BuildFailure e) {
            throw new ModelServiceException(e);
        }
        return result;
    }

    @Override
    public List<ModelRelation> getInboundRelationsNamed(ModelRequestContext context, Path forObject, String named) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        ModelMount mm = this.getModelForPath(forObject);
        try {
            ModelRequestContext mrc = mm.getModel().getRequestContextBuilder().forUser(context.getOperator()).build();
            for (ModelRelation mrInternal : mm.getModel().getInboundRelationsNamed(mrc, mm.getPathWithinModel(forObject), named)) {
                result.add(new ToGlobalMapper(mm, mrInternal));
            }
        }
        catch (Builder.BuildFailure e) {
            throw new ModelServiceException(e);
        }
        return result;
    }

    @Override
    public List<ModelRelation> getOutboundRelationsNamed(ModelRequestContext context, Path forObject, String named) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        ModelMount mm = this.getModelForPath(forObject);
        try {
            ModelRequestContext mrc = mm.getModel().getRequestContextBuilder().forUser(context.getOperator()).build();
            for (ModelRelation mrInternal : mm.getModel().getOutboundRelationsNamed(mrc, mm.getPathWithinModel(forObject), named)) {
                result.add(new ToGlobalMapper(mm, mrInternal));
            }
        }
        catch (Builder.BuildFailure e) {
            throw new ModelServiceException(e);
        }
        return result;
    }

    private ModelMount getModelForPath(Path modelPath) {
        for (ModelMount mountEntry : this.fUserMountTable) {
            if (!mountEntry.contains(modelPath)) continue;
            return mountEntry;
        }
        return new ModelMount(){

            public JSONObject toJson() {
                return new JSONObject();
            }

            @Override
            public Path getMountPoint() {
                return Path.getRootPath();
            }

            @Override
            public boolean contains(Path path) {
                return true;
            }

            @Override
            public Model getModel() {
                return DelegatingModel.this;
            }

            @Override
            public Path getPathWithinModel(Path absolutePath) {
                return absolutePath;
            }

            @Override
            public Path getGlobalPath(Path from) {
                return null;
            }
        };
    }

    private static class ToGlobalMapper
    implements ModelRelation {
        private final ModelRelation fInternalReln;
        private final ModelMount fModelMount;

        public ToGlobalMapper(ModelMount mount, ModelRelation internal) {
            this.fModelMount = mount;
            this.fInternalReln = internal;
        }

        @Override
        public Path getFrom() {
            return this.fModelMount.getGlobalPath(this.fInternalReln.getFrom());
        }

        @Override
        public Path getTo() {
            return this.fModelMount.getGlobalPath(this.fInternalReln.getTo());
        }

        @Override
        public String getName() {
            return this.fInternalReln.getName();
        }
    }
}

