/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.api.endpoints;

import io.continual.builder.Builder;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.services.model.api.endpoints.ModelApiContextHelper;
import io.continual.services.model.api.endpoints.ObjectRenderer;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelUpdater;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.core.updaters.DataMerge;
import io.continual.services.model.core.updaters.DataOverwrite;
import io.continual.services.model.service.ModelService;
import io.continual.services.model.service.ModelSession;
import io.continual.util.collections.MultiMap;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Path;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ObjectApi
extends ModelApiContextHelper {
    public ObjectApi(ModelService ms) {
        super(ms);
    }

    public void getObject(CHttpRequestContext context) throws IOException, ModelRequestException {
        this.getObject(context, "/");
    }

    private ModelRequestContext makeMrc(ModelApiContextHelper.ModelApiContext modelApiContext, ModelSession ms) throws Builder.BuildFailure {
        return ms.getModel().getRequestContextBuilder().forUser(modelApiContext.getUserContext().getUser()).withSchemasFrom(ms.getSchemaRegistry()).withNotificationsTo(ms.getNotificationSvc()).build();
    }

    public void getObject(CHttpRequestContext context, final String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure, ModelServiceException {
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                Model model = ms.getModel();
                if (model.exists(mrc, requestedPath)) {
                    ModelObject mo = ms.getModel().load(mrc, requestedPath);
                    modelApiContext.respondOk(new JSONObject().put("status", 200).put("request", (Object)requestedPath.toString()).put("object", (Object)new ObjectRenderer().withData(mo).render()));
                } else {
                    modelApiContext.respondWithStatus(404, new JSONObject().put("path", (Object)objectPath.toString()));
                }
            }
        });
    }

    public void putObject(final CHttpRequestContext context, String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                JSONObject obj = ObjectApi.readPayload(context);
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                ms.getModel().store(mrc, requestedPath, new ModelUpdater[]{new DataOverwrite(obj)});
                modelApiContext.respondWithStatus(204, null);
            }
        });
    }

    public void patchObject(final CHttpRequestContext context, String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                JSONObject obj = ObjectApi.readPayload(context);
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                ms.getModel().store(mrc, requestedPath, new ModelUpdater[]{new DataMerge(obj)});
                modelApiContext.respondWithStatus(204, null);
            }
        });
    }

    public void deleteObject(CHttpRequestContext context, String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                boolean removal = ms.getModel().remove(mrc, requestedPath);
                modelApiContext.respondWithStatus(200, new JSONObject().put("removal", removal));
            }
        });
    }

    public void putRelation(CHttpRequestContext context, String fromObjPath, final String relation, final String toObjPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, fromObjPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                final Path toPath = ModelApiContextHelper.fixupPath(toObjPath);
                ModelSession ms = modelApiContext.getModelSession();
                final Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                ms.getModel().relate(mrc, new ModelRelation(){

                    public Path getFrom() {
                        return requestedPath;
                    }

                    public Path getTo() {
                        return toPath;
                    }

                    public String getName() {
                        return relation;
                    }
                });
                modelApiContext.respondWithStatus(204, null);
            }
        });
    }

    public void deleteRelation(CHttpRequestContext context, String fromObjPath, final String relation, final String toObjPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, fromObjPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                final Path toPath = ModelApiContextHelper.fixupPath(toObjPath);
                ModelSession ms = modelApiContext.getModelSession();
                final Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                boolean removal = ms.getModel().unrelate(mrc, new ModelRelation(){

                    public Path getFrom() {
                        return requestedPath;
                    }

                    public Path getTo() {
                        return toPath;
                    }

                    public String getName() {
                        return relation;
                    }
                });
                modelApiContext.respondWithStatus(200, new JSONObject().put("removal", removal));
            }
        });
    }

    public void getOutboundRelations(final CHttpRequestContext context, String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                List relns = ms.getModel().getOutboundRelationsNamed(mrc, requestedPath, context.request().getParameter("rn", null));
                modelApiContext.respondOk(new JSONObject().put("status", 200).put("request", (Object)requestedPath.toString()).put("relations", (Object)new JSONObject().put("out", (Object)ObjectApi.renderRelnSet(relns, false))));
            }
        });
    }

    public void getInboundRelations(final CHttpRequestContext context, String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                List relns = ms.getModel().getInboundRelationsNamed(mrc, requestedPath, context.request().getParameter("rn", null));
                modelApiContext.respondOk(new JSONObject().put("status", 200).put("request", (Object)requestedPath.toString()).put("relations", (Object)new JSONObject().put("in", (Object)ObjectApi.renderRelnSet(relns, true))));
            }
        });
    }

    public void getAllRelations(CHttpRequestContext context, String objectPath) throws IOException, ModelRequestException {
        this.handleModelRequest(context, null, objectPath, new ModelApiContextHelper.ModelApiHandler(){

            @Override
            public void handle(ModelApiContextHelper.ModelApiContext modelApiContext) throws IOException, JSONException, ModelServiceException, IamSvcException, ModelItemDoesNotExistException, ModelRequestException, Builder.BuildFailure {
                ModelSession ms = modelApiContext.getModelSession();
                Path requestedPath = modelApiContext.getRequestedPath();
                ModelRequestContext mrc = ObjectApi.this.makeMrc(modelApiContext, ms);
                List inRelns = ms.getModel().getInboundRelations(mrc, requestedPath);
                List outRelns = ms.getModel().getOutboundRelations(mrc, requestedPath);
                modelApiContext.respondOk(new JSONObject().put("status", 200).put("request", (Object)requestedPath.toString()).put("relations", (Object)new JSONObject().put("in", (Object)ObjectApi.renderRelnSet(inRelns, true)).put("out", (Object)ObjectApi.renderRelnSet(outRelns, false))));
            }
        });
    }

    private static JSONObject readPayload(CHttpRequestContext context) throws IOException, ModelRequestException {
        try {
            return new JSONObject((JSONTokener)new CommentedJsonTokener(context.request().getBodyStream()));
        }
        catch (JSONException e) {
            throw new ModelRequestException("Couldn't parse your JSON.");
        }
    }

    private static JSONObject renderRelnSet(List<ModelRelation> relns, boolean fromSide) {
        MultiMap relnMap = new MultiMap();
        for (ModelRelation mr : relns) {
            relnMap.put((Object)mr.getName(), (Object)(fromSide ? mr.getFrom() : mr.getTo()));
        }
        JSONObject obj = new JSONObject();
        for (String relnName : relnMap.getKeys()) {
            List targets = relnMap.get((Object)relnName);
            obj.put(relnName, (Object)JsonVisitor.listToArray((Collection)targets, (JsonVisitor.ItemRenderer)new JsonVisitor.ItemRenderer<Path, String>(){

                public String render(Path p) {
                    return p.getId();
                }
            }));
        }
        return obj;
    }
}

