/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.api.endpoints;

import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelRelation;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ObjectRenderer {
    private ModelObject fMoc = null;
    private List<ModelRelation> fRelns = null;
    private String fDir = null;
    private String fRelnName = null;

    public ObjectRenderer withData(ModelObject o) {
        this.fMoc = o;
        return this;
    }

    public ObjectRenderer withRelations(List<ModelRelation> relns) {
        this.fRelns = relns;
        return this;
    }

    public ObjectRenderer withInboundRelnsOnly() {
        this.fDir = "in";
        return this;
    }

    public ObjectRenderer withOutboundRelnsOnly() {
        this.fDir = "out";
        return this;
    }

    public ObjectRenderer withRelnName(String name) {
        this.fRelnName = name;
        return this;
    }

    public String renderText() {
        return this.render().toString();
    }

    public JSONObject render() {
        JSONObject result = new JSONObject();
        if (this.fMoc != null) {
            result.put("data", (Object)this.fMoc.getData()).put("meta", (Object)this.fMoc.getMetadata().toJson());
        }
        if (this.fRelns != null) {
            JSONArray relnArr = new JSONArray();
            for (ModelRelation r : this.fRelns) {
                JSONObject relnO = new JSONObject().put("from", (Object)r.getFrom()).put("to", (Object)r.getTo()).put("name", (Object)r.getName());
                relnArr.put((Object)relnO);
            }
            JSONObject relns = new JSONObject().put("set", (Object)relnArr);
            if (this.fDir != null) {
                JSONObject filter = new JSONObject().put("set", (Object)this.fDir);
                if (this.fRelnName != null) {
                    filter.put("name", (Object)this.fRelnName);
                }
                relns.put("filter", (Object)filter);
            }
            result.put("relations", (Object)relns);
        }
        return result;
    }
}

