/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.service.impl;

import io.continual.services.model.core.Model;
import io.continual.services.model.impl.delegator.ModelMount;
import io.continual.util.naming.Path;
import org.json.JSONObject;

class StdMountTableEntry
implements ModelMount {
    final Path fMountPoint;
    private final Model fModel;

    public StdMountTableEntry(Path mountPoint, Model m) {
        this.fMountPoint = mountPoint;
        this.fModel = m;
    }

    public boolean contains(Path path) {
        return path.startsWith(this.fMountPoint);
    }

    public Path getMountPoint() {
        return this.fMountPoint;
    }

    public Model getModel() {
        return this.fModel;
    }

    public Path getPathWithinModel(Path absolutePath) {
        return absolutePath.makePathWithinParent(this.fMountPoint);
    }

    public Path getGlobalPath(Path from) {
        return this.fMountPoint.makeChildPath(from);
    }

    public JSONObject toJson() {
        return new JSONObject().put("path", (Object)this.fMountPoint.toString()).put("model", (Object)new JSONObject().put("acctId", (Object)this.fModel.getAcctId()).put("id", (Object)this.fModel.getId()));
    }

    public String toString() {
        return this.getModel().toString() + " @ " + this.getMountPoint().toString();
    }
}

