/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.common;

import io.continual.resources.ResourceLoader;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelSchema;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.collections.LruCache;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class BuiltinSchemaReg
implements ModelSchemaRegistry {
    private final LruCache<String, JsonModelSchema> fSchemaCache;

    public BuiltinSchemaReg(long schemaCacheSize) {
        this.fSchemaCache = new LruCache(schemaCacheSize);
    }

    @Override
    public ModelSchema getSchema(String name) throws ModelServiceException {
        JSONObject schemaObj;
        JsonModelSchema schema = (JsonModelSchema)this.fSchemaCache.get((Object)name);
        if (schema == null && (schemaObj = this.load(name, "io.continual.services.model.types.basic." + name)) != null) {
            schema = new JsonModelSchema(schemaObj);
            this.fSchemaCache.put((Object)name, (Object)schema);
        }
        return schema;
    }

    private JSONObject load(String ... names) {
        for (String name : names) {
            try {
                InputStream is = new ResourceLoader().named(name).usingStandardSources(false).load();
                if (is == null) continue;
                return new JSONObject((JSONTokener)new CommentedJsonTokener(is));
            }
            catch (IOException | JSONException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private class JsonModelSchema
    implements ModelSchema {
        private final Schema fSchema;

        public JsonModelSchema(JSONObject schemaJson) {
            this.fSchema = SchemaLoader.load((JSONObject)schemaJson);
        }

        @Override
        public ModelSchema.ValidationResult isValid(ModelObject object) throws ModelServiceException {
            try {
                this.fSchema.validate((Object)object.getData());
                return ModelSchema.buildPassingResult();
            }
            catch (ValidationException e) {
                return new ModelSchema.ValidationResult(){

                    @Override
                    public boolean isValid() {
                        return false;
                    }

                    @Override
                    public List<String> getProblems() {
                        return e.getAllMessages();
                    }
                };
            }
        }
    }
}

