/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.files;

import io.continual.builder.Builder;
import io.continual.services.model.core.ModelRelation;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.util.data.json.CommentedJsonTokener;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Name;
import io.continual.util.naming.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONTokener;

class FileSysRelnMgr {
    private final File fRelnDir;

    public FileSysRelnMgr(File relnDir) throws Builder.BuildFailure {
        this.fRelnDir = relnDir;
        if (!this.fRelnDir.exists() && !this.fRelnDir.mkdir()) {
            throw new Builder.BuildFailure("Failed to create " + relnDir.toString());
        }
        if (!this.fRelnDir.isDirectory()) {
            throw new Builder.BuildFailure(relnDir.toString() + " exists and is not a directory.");
        }
    }

    public void relate(ModelRelation mr) throws ModelServiceException, ModelRequestException {
        this.addToRelnFile(this.pathToObjOutDir(mr.getFrom()), mr.getName(), mr.getTo());
        this.addToRelnFile(this.pathToObjInDir(mr.getTo()), mr.getName(), mr.getFrom());
    }

    public boolean unrelate(ModelRelation reln) throws ModelServiceException, ModelRequestException {
        boolean out = this.removeFromRelnFile(new File(this.pathToObjOutDir(reln.getFrom()), reln.getName()), reln.getTo());
        boolean in = this.removeFromRelnFile(new File(this.pathToObjInDir(reln.getTo()), reln.getName()), reln.getFrom());
        return out || in;
    }

    public List<ModelRelation> getInboundRelations(Path forObject) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        File objDir = this.pathToObjInDir(forObject);
        if (objDir.isDirectory()) {
            for (File reln : objDir.listFiles()) {
                result.addAll(this.getRelationsFrom(forObject, reln, false));
            }
        }
        return result;
    }

    public List<ModelRelation> getOutboundRelations(Path forObject) throws ModelServiceException, ModelRequestException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        File objDir = this.pathToObjOutDir(forObject);
        if (objDir.isDirectory()) {
            for (File reln : objDir.listFiles()) {
                result.addAll(this.getRelationsFrom(forObject, reln, true));
            }
        }
        return result;
    }

    public List<ModelRelation> getInboundRelationsNamed(Path forObject, String named) throws ModelServiceException, ModelRequestException {
        if (named == null) {
            return this.getInboundRelations(forObject);
        }
        File reln = new File(this.pathToObjInDir(forObject), named);
        if (reln.exists()) {
            return this.getRelationsFrom(forObject, reln, false);
        }
        return new LinkedList<ModelRelation>();
    }

    public List<ModelRelation> getOutboundRelationsNamed(Path forObject, String named) throws ModelServiceException, ModelRequestException {
        if (named == null) {
            return this.getOutboundRelations(forObject);
        }
        File reln = new File(this.pathToObjOutDir(forObject), named);
        if (reln.exists()) {
            return this.getRelationsFrom(forObject, reln, true);
        }
        return new LinkedList<ModelRelation>();
    }

    private List<ModelRelation> getRelationsFrom(final Path forObject, File reln, final boolean objIsFromSide) throws ModelServiceException {
        LinkedList<ModelRelation> result = new LinkedList<ModelRelation>();
        final String relnName = reln.getName();
        for (final Path to : this.loadToSet(reln)) {
            result.add(new ModelRelation(){

                @Override
                public Path getFrom() {
                    return objIsFromSide ? forObject : to;
                }

                @Override
                public Path getTo() {
                    return objIsFromSide ? to : forObject;
                }

                @Override
                public String getName() {
                    return relnName;
                }
            });
        }
        return result;
    }

    private Set<Path> loadToSet(File relnFile) throws ModelServiceException {
        block9: {
            if (relnFile.exists()) {
                TreeSet<Path> treeSet;
                FileInputStream fis2 = new FileInputStream(relnFile);
                try {
                    JSONArray ar = new JSONArray((JSONTokener)new CommentedJsonTokener((InputStream)fis2));
                    List list = JsonVisitor.arrayToList((JSONArray)ar, (JsonVisitor.ValueReader)new JsonVisitor.ValueReader<String, Path>(){

                        public Path read(String val) {
                            return Path.fromString((String)val);
                        }
                    });
                    TreeSet<Path> result = new TreeSet<Path>();
                    result.addAll(list);
                    treeSet = result;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fis2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException fis2) {
                        break block9;
                    }
                    catch (IOException | JSONException x) {
                        throw new ModelServiceException(x);
                    }
                }
                fis2.close();
                return treeSet;
            }
        }
        return new TreeSet<Path>();
    }

    private void storeToFile(File relnFile, Set<Path> list) throws ModelServiceException {
        JSONArray arr = JsonVisitor.listToArray(list, (JsonVisitor.ItemRenderer)new JsonVisitor.ItemRenderer<Path, String>(){

            public String render(Path t) {
                return t.toString();
            }
        });
        try (FileWriter fw = new FileWriter(relnFile);){
            fw.write(arr.toString());
        }
        catch (IOException x) {
            throw new ModelServiceException(x);
        }
    }

    private File pathToObjDir(Path from) {
        File result = this.fRelnDir;
        for (Name component : from.getSegmentList()) {
            result = new File(result, component.toString());
        }
        return result;
    }

    private File pathToObjOutDir(Path from) {
        return new File(this.pathToObjDir(from), "out");
    }

    private File pathToObjInDir(Path from) {
        return new File(this.pathToObjDir(from), "in");
    }

    private void addToRelnFile(File targetDir, String relnName, Path farSide) throws ModelServiceException {
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            throw new ModelServiceException("Couldn't create relation directory " + targetDir.toString());
        }
        File pathFile = new File(targetDir, relnName);
        Set<Path> farSideList = this.loadToSet(pathFile);
        farSideList.add(farSide);
        this.storeToFile(pathFile, farSideList);
    }

    private boolean removeFromRelnFile(File relnFile, Path farSide) throws ModelServiceException {
        Set<Path> toList;
        if (relnFile.exists() && (toList = this.loadToSet(relnFile)).contains(farSide)) {
            toList.remove(farSide);
            this.storeToFile(relnFile, toList);
            return true;
        }
        return false;
    }
}

