/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.json;

import io.continual.iam.access.AccessControlList;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import io.continual.services.model.core.Model;
import io.continual.services.model.core.ModelNotificationService;
import io.continual.services.model.core.ModelObject;
import io.continual.services.model.core.ModelOperation;
import io.continual.services.model.core.ModelRequestContext;
import io.continual.services.model.core.ModelSchema;
import io.continual.services.model.core.ModelSchemaRegistry;
import io.continual.services.model.core.ModelUpdater;
import io.continual.services.model.core.exceptions.ModelItemDoesNotExistException;
import io.continual.services.model.core.exceptions.ModelRequestException;
import io.continual.services.model.core.exceptions.ModelServiceException;
import io.continual.services.model.impl.json.CommonJsonDbObject;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Path;
import java.io.IOException;
import org.json.JSONObject;

public abstract class CommonJsonDbModel
extends SimpleService
implements Model {
    private final String fAcctId;
    private final String fModelId;
    public static final String kMetadataTag = "\u24c2";
    public static final String kUserDataTag = "\u24ca";

    public CommonJsonDbModel(ServiceContainer sc, JSONObject config) {
        this(config.getString("acctId"), config.getString("modelId"));
    }

    public CommonJsonDbModel(String acctId, String modelId) {
        this.fAcctId = acctId;
        this.fModelId = modelId;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getAcctId() {
        return this.fAcctId;
    }

    @Override
    public String getId() {
        return this.fModelId;
    }

    @Override
    public long getMaxSerializedObjectLength() {
        return 0x40000000L;
    }

    @Override
    public long getMaxPathLength() {
        return 1024L;
    }

    @Override
    public long getMaxRelnNameLength() {
        return 1024L;
    }

    @Override
    public boolean exists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        if (context.knownToNotExist(objectPath)) {
            return false;
        }
        boolean result = this.objectExists(context, objectPath);
        if (!result) {
            context.doesNotExist(objectPath);
        }
        return result;
    }

    @Override
    public ModelObject load(ModelRequestContext context, Path objectPath) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException {
        if (context.knownToNotExist(objectPath)) {
            throw new ModelItemDoesNotExistException(objectPath);
        }
        ModelObject result = context.get(objectPath);
        if (result != null) {
            return result;
        }
        result = this.loadObject(context, objectPath);
        if (result == null) {
            context.doesNotExist(objectPath);
        } else {
            context.put(objectPath, result);
        }
        return result;
    }

    @Override
    public void store(ModelRequestContext context, Path objectPath, ModelUpdater ... updates) throws ModelRequestException, ModelServiceException {
        try {
            boolean isCreate = !this.exists(context, objectPath);
            ModelObject o = isCreate ? this.initializeObject(context) : this.load(context, objectPath);
            for (ModelUpdater mu : updates) {
                ModelOperation[] accessList;
                AccessControlList acl = o.getAccessControlList();
                for (ModelOperation access : accessList = mu.getAccessRequired()) {
                    if (acl.canUser(context.getOperator(), access.toString())) continue;
                    throw new ModelRequestException(context.getOperator().getId() + " may not " + access + " " + objectPath.toString() + ".");
                }
                mu.update(context, o);
            }
            ModelSchemaRegistry schemas = context.getSchemaRegistry();
            for (String type : o.getMetadata().getLockedTypes()) {
                ModelSchema ms = schemas.getSchema(type);
                if (ms == null) {
                    throw new ModelRequestException("Unknown type " + type);
                }
                ModelSchema.ValidationResult vr = ms.isValid(o);
                if (vr.isValid()) continue;
                throw new ModelRequestException("The object does not meet type " + type, new JSONObject().put("validationProblems", (Object)JsonVisitor.listToArray(vr.getProblems())));
            }
            this.internalStore(context, objectPath, o);
            context.put(objectPath, o);
            ModelNotificationService ns = context.getNotificationService();
            if (isCreate) {
                ns.onObjectCreate(objectPath);
            } else {
                ns.onObjectUpdate(objectPath);
            }
        }
        catch (IamSvcException e) {
            throw new ModelServiceException(e);
        }
    }

    @Override
    public boolean remove(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        boolean result = this.internalRemove(context, objectPath);
        context.remove(objectPath);
        context.getNotificationService().onObjectDelete(objectPath);
        return result;
    }

    protected ModelObject initializeObject(ModelRequestContext context) throws ModelRequestException {
        Identity id = context.getOperator();
        if (id == null) {
            throw new ModelRequestException("No operator identity provided in request context.");
        }
        CommonJsonDbObject result = new CommonJsonDbObject();
        result.getAccessControlList().setOwner(id.getId()).permit("~owner~", ModelOperation.kAllOperationStrings);
        return result;
    }

    protected boolean objectExists(ModelRequestContext context, Path objectPath) throws ModelServiceException, ModelRequestException {
        try {
            this.load(context, objectPath);
            return true;
        }
        catch (ModelItemDoesNotExistException e) {
            return false;
        }
    }

    protected abstract ModelObject loadObject(ModelRequestContext var1, Path var2) throws ModelItemDoesNotExistException, ModelServiceException, ModelRequestException;

    protected abstract void internalStore(ModelRequestContext var1, Path var2, ModelObject var3) throws ModelRequestException, ModelServiceException;

    protected abstract boolean internalRemove(ModelRequestContext var1, Path var2) throws ModelRequestException, ModelServiceException;
}

