/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.impl.json;

import io.continual.services.model.impl.json.CommonJsonDbObject;
import io.continual.util.data.json.JsonVisitor;
import io.continual.util.naming.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class CommonJsonDbObjectContainer
extends CommonJsonDbObject {
    public static CommonJsonDbObjectContainer createObjectContainer(String id, Path containedPath) {
        return CommonJsonDbObjectContainer.createObjectContainer(id, Collections.singletonList(containedPath));
    }

    public static CommonJsonDbObjectContainer createObjectContainer(String id, Path ... containedPaths) {
        return CommonJsonDbObjectContainer.createObjectContainer(id, Arrays.asList(containedPaths));
    }

    public static CommonJsonDbObjectContainer createObjectContainer(String id, List<Path> containedPaths) {
        return new CommonJsonDbObject.Builder().withId(id).withData(new JSONObject().put("objects", (Object)JsonVisitor.collectionToArray(containedPaths, (JsonVisitor.ItemRenderer)new JsonVisitor.ItemRenderer<Path, String>(){

            public String render(Path t) {
                return t.toString();
            }
        })), true).withType("ObjectContainer").constructUsing(new CommonJsonDbObject.Builder.Constructor<CommonJsonDbObjectContainer>(){

            @Override
            public CommonJsonDbObjectContainer construct(String id, JSONObject rawData) {
                return new CommonJsonDbObjectContainer(id, rawData);
            }
        }).build();
    }

    private CommonJsonDbObjectContainer(String id, JSONObject rawData) {
        super(id, rawData);
    }
}

