/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpServlet;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.iam.IamService;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.MetricsService;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpServlet;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.util.data.StreamTools;
import io.continual.util.data.json.JsonVisitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.Http11NioProtocol;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService
implements Service {
    private final String kSetting_ServletWorkDir = "workDir";
    private final String kDefault_ServletWorkDir;
    private final String kSetting_Keystore = "keystore";
    private final String kSetting_KeystoreFile = "file";
    private final String kSetting_KeystoreAlias = "alias";
    private final String kDefault_KeystoreAlias = "tomcat";
    private final String kSetting_KeystoreAliasScan = "scanForAlias";
    private final String kSetting_KeystorePassword = "password";
    private final String kDefault_KeystorePassword = "changeme";
    private final String kSetting_KeystorePasswordFile = "passwordFile";
    private final String kSetting_Port = "port";
    private final ServiceContainer fServices;
    private final IamService<?, ?> fAccounts;
    private final MetricsCatalog fMetrics;
    private final CHttpObserverMgr fInspector;
    private final JSONObject fSettings;
    private final Tomcat fTomcat;
    private boolean fRunning;
    private final HashMap<String, HttpRouter> fServlets;
    private final File fWorkDir;
    private static final Logger log = LoggerFactory.getLogger(HttpService.class);

    public HttpService(ServiceContainer sc, JSONObject settings) throws Builder.BuildFailure {
        this(sc, settings, settings.optString("name", "default"), settings.optInt("port", 8080));
    }

    protected HttpService(ServiceContainer sc, JSONObject settings, String serviceName, int defaultPort) throws Builder.BuildFailure {
        block28: {
            this.kSetting_ServletWorkDir = "workDir";
            this.kDefault_ServletWorkDir = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
            this.kSetting_Keystore = "keystore";
            this.kSetting_KeystoreFile = "file";
            this.kSetting_KeystoreAlias = "alias";
            this.kDefault_KeystoreAlias = "tomcat";
            this.kSetting_KeystoreAliasScan = "scanForAlias";
            this.kSetting_KeystorePassword = "password";
            this.kDefault_KeystorePassword = "changeme";
            this.kSetting_KeystorePasswordFile = "passwordFile";
            this.kSetting_Port = "port";
            try {
                Connector connector;
                int port;
                this.fServices = sc;
                String acctsServiceName = settings.optString("accountService", null);
                this.fAccounts = acctsServiceName != null ? (IamService)this.fServices.get(acctsServiceName, IamService.class) : null;
                String metricsServiceName = settings.optString("metricsService", null);
                if (metricsServiceName != null) {
                    MetricsService ms = (MetricsService)this.fServices.get(metricsServiceName, MetricsService.class);
                    if (ms == null) {
                        throw new Builder.BuildFailure("Metrics service specified as " + metricsServiceName + " but the service was not found.");
                    }
                    this.fMetrics = ms.getCatalog("http");
                } else {
                    this.fMetrics = null;
                }
                String inspectionServiceName = settings.optString("inspector", null);
                if (inspectionServiceName != null) {
                    this.fInspector = (CHttpObserverMgr)this.fServices.get(inspectionServiceName, CHttpObserverMgr.class);
                    if (this.fInspector == null) {
                        throw new Builder.BuildFailure("Inspector service specified as \"" + inspectionServiceName + "\" but the service was not found.");
                    }
                } else {
                    this.fInspector = null;
                }
                this.fSettings = settings;
                this.fRunning = false;
                this.fServlets = new HashMap();
                System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
                this.fTomcat = new Tomcat();
                String servletWorkDir = settings.optString("workDir", this.kDefault_ServletWorkDir);
                this.fWorkDir = new File(servletWorkDir);
                if (!this.fWorkDir.exists()) {
                    this.fWorkDir.mkdirs();
                }
                JSONObject httpConfig = settings.optJSONObject("http");
                JSONObject httpsConfig = settings.optJSONObject("https");
                if (httpConfig == null && httpsConfig == null) {
                    httpConfig = new JSONObject().put("port", settings.optInt("port", defaultPort));
                }
                if (httpConfig != null) {
                    port = httpConfig.optInt("port", defaultPort);
                    if (port > 0) {
                        connector = new Connector(Http11NioProtocol.class.getName());
                        connector.setPort(port);
                        this.transferConnectorAttributes(connector, httpConfig.optJSONObject("tomcat"));
                        this.fTomcat.getService().addConnector(connector);
                        log.info("Service [" + this.fSettings.optString("name", "<anonymous>") + "] listens for HTTP on " + port + ".");
                    } else {
                        log.info("Service [" + this.fSettings.optString("name", "<anonymous>") + "] will not listen for HTTP.");
                    }
                }
                if (httpsConfig == null) break block28;
                port = httpsConfig.optInt("port", defaultPort);
                if (port > 0) {
                    connector = new Connector(Http11NioProtocol.class.getName());
                    JSONObject keystoreConfig = httpsConfig.getJSONObject("keystore");
                    String keystoreFilename = keystoreConfig.getString("file");
                    File keystoreFile = new File(keystoreFilename);
                    if (!keystoreFile.isAbsolute()) {
                        Path path = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                        File file = new File(path.toFile(), keystoreFilename);
                        keystoreFilename = file.getAbsolutePath();
                        log.info("Using absolute path [" + keystoreFilename + "] for keystore.");
                    }
                    String keystorePassword = "changeme";
                    if (keystoreConfig.has("password")) {
                        keystorePassword = keystoreConfig.getString("password");
                    } else if (keystoreConfig.has("passwordFile")) {
                        String pwdFileName = keystoreConfig.optString("passwordFile", null);
                        File pwdFile = new File(pwdFileName);
                        try (FileInputStream fis = new FileInputStream(pwdFile);){
                            byte[] pwdData = StreamTools.readBytes((InputStream)fis);
                            keystorePassword = new String(pwdData).trim();
                        }
                        catch (IOException x) {
                            log.warn("There was a problem trying to read {}: {}", (Object)pwdFileName, (Object)x.getMessage());
                        }
                    }
                    String keystoreAlias = "tomcat";
                    if (keystoreConfig.has("alias")) {
                        keystoreAlias = keystoreConfig.getString("alias");
                    } else if (keystoreConfig.optBoolean("scanForAlias", false)) {
                        keystoreAlias = HttpService.scanKeystoreForPrivateKey(keystoreFilename, keystorePassword);
                    }
                    connector.setScheme("https");
                    connector.setSecure(true);
                    connector.setProperty("keystoreFile", keystoreFilename);
                    connector.setProperty("keystorePass", keystorePassword);
                    connector.setProperty("keyAlias", keystoreAlias);
                    connector.setProperty("clientAuth", "false");
                    connector.setProperty("sslProtocol", "TLS");
                    connector.setProperty("SSLEnabled", "true");
                    connector.setPort(port);
                    this.transferConnectorAttributes(connector, httpConfig.optJSONObject("tomcat"));
                    this.fTomcat.getService().addConnector(connector);
                    log.info("Service [" + this.fSettings.optString("name", "<anonymous>") + "] listens for HTTPS on " + port + ".");
                    break block28;
                }
                log.info("Service [" + this.fSettings.optString("name", "<anonymous>") + "] will not listen for HTTPS.");
            }
            catch (JSONException x) {
                throw new Builder.BuildFailure((Throwable)x);
            }
        }
    }

    public HttpService addRouter(String servletName, HttpRouter s) {
        this.fServlets.put(servletName, s);
        return this;
    }

    public void start() throws Service.FailedToStart {
        block6: {
            try {
                if (this.fSettings.optBoolean("enabled", true)) {
                    HttpServlet hs = new HttpServlet(this.fServices, this.fAccounts, CHttpServlet.SessionLifeCycle.valueOf((String)this.fSettings.optString("lifeCycle", CHttpServlet.SessionLifeCycle.NO_SESSION.toString())), this.fSettings, this.fMetrics, this.fInspector);
                    for (Map.Entry<String, HttpRouter> s : this.fServlets.entrySet()) {
                        hs.addRouter(s.getValue());
                    }
                    String servletName = "httpService";
                    Context rootCtx = this.fTomcat.addContext("", this.fWorkDir.getAbsolutePath());
                    Tomcat.addServlet((Context)rootCtx, (String)"httpService", (Servlet)hs);
                    rootCtx.addServletMappingDecoded("/*", "httpService");
                    try {
                        this.fTomcat.start();
                        this.fRunning = true;
                    }
                    catch (LifecycleException e) {
                        log.warn("Couldn't start tomcat.", (Throwable)e);
                        this.fRunning = false;
                    }
                    log.info("Service [" + this.fSettings.optString("name", "<anonymous>") + "] is listening.");
                    break block6;
                }
                log.info("Service [" + this.fSettings.optString("name", "<anonymous>") + "] is disabled.");
            }
            catch (Builder.BuildFailure x) {
                throw new Service.FailedToStart((Throwable)x);
            }
        }
    }

    public void requestFinish() {
        try {
            this.fTomcat.stop();
            this.fRunning = false;
        }
        catch (LifecycleException e) {
            log.warn("Couldn't stop tomcat.", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.fRunning;
    }

    private void transferConnectorAttributes(final Connector connector, JSONObject config) {
        if (config == null) {
            return;
        }
        JsonVisitor.forEachElement((JSONObject)config, (JsonVisitor.ObjectVisitor)new JsonVisitor.ObjectVisitor<Object, JSONException>(){

            public boolean visit(String key, Object val) throws JSONException {
                connector.setProperty(key, String.valueOf(val));
                return true;
            }
        });
    }

    private static String scanKeystoreForPrivateKey(String keystoreFilename, String keystorePassword) {
        try {
            log.info("Scanning {} for its first private key...", (Object)keystoreFilename);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(keystoreFilename), keystorePassword.toCharArray());
            log.info("Keystore {} loaded...", (Object)keystoreFilename);
            Enumeration<String> enumeration = ks.aliases();
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!ks.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
                log.info("Found private key {}.", (Object)alias);
                return alias;
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException x) {
            log.warn("Exception inspecting keystore {} for alias: {}", (Object)keystoreFilename, (Object)x.getMessage());
        }
        return "";
    }
}

