/*
 * Decompiled with CFR 0.152.
 */
package io.continual.restHttp;

import io.continual.builder.Builder;
import io.continual.http.service.framework.CHttpMetricNamer;
import io.continual.http.service.framework.CHttpServlet;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.http.service.framework.inspection.CHttpObserverMgr;
import io.continual.http.service.framework.routing.CHttpRequestRouter;
import io.continual.iam.IamService;
import io.continual.metrics.MetricsCatalog;
import io.continual.restHttp.HttpRouter;
import io.continual.restHttp.HttpUserSession;
import io.continual.services.ServiceContainer;
import io.continual.util.nv.NvReadable;
import io.continual.util.nv.impl.nvJsonObject;
import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.ServletException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServlet
extends CHttpServlet {
    private final ServiceContainer fContainer;
    private final IamService<?, ?> fAccounts;
    private final LinkedList<HttpRouter> fRouters;
    private final CHttpMetricNamer fMetricNamer;
    private static final Logger log = LoggerFactory.getLogger(HttpServlet.class);
    private static final long serialVersionUID = 1L;

    public HttpServlet(ServiceContainer sc, IamService<?, ?> accounts, CHttpServlet.SessionLifeCycle lc, JSONObject settings, MetricsCatalog metrics) throws Builder.BuildFailure {
        this(sc, accounts, lc, settings, metrics, null);
    }

    public HttpServlet(ServiceContainer sc, IamService<?, ?> accounts, CHttpServlet.SessionLifeCycle lc, JSONObject settings, MetricsCatalog metrics, CHttpObserverMgr inspector) throws Builder.BuildFailure {
        super((NvReadable)new nvJsonObject(settings), null, lc, metrics, inspector);
        this.fAccounts = accounts;
        this.fContainer = sc;
        this.fRouters = new LinkedList();
        JSONObject namer = settings.optJSONObject("metricsNamer");
        this.fMetricNamer = namer != null ? (CHttpMetricNamer)Builder.withBaseClass(CHttpMetricNamer.class).withClassNameInData().usingData(namer).build() : null;
    }

    public void addRouter(HttpRouter value) {
        this.fRouters.add(value);
    }

    public ServiceContainer getServices() {
        return this.fContainer;
    }

    public static HttpServlet getServlet(CHttpRequestContext rc) {
        CHttpServlet ds = rc.getServlet();
        if (!(ds instanceof HttpServlet)) {
            throw new IllegalStateException("This servlet is not an HttpServlet");
        }
        return (HttpServlet)ds;
    }

    public static ServiceContainer getServices(CHttpRequestContext rc) {
        CHttpServlet ds = rc.getServlet();
        if (!(ds instanceof HttpServlet)) {
            throw new IllegalStateException("This servlet is not an HttpServlet");
        }
        return ((HttpServlet)ds).getServices();
    }

    public HttpUserSession createSession() throws NvReadable.MissingReqdSettingException {
        return new HttpUserSession(this.fAccounts);
    }

    protected void servletSetup() throws NvReadable.MissingReqdSettingException, ServletException {
        try {
            NvReadable p = super.getSettings();
            CHttpRequestRouter rr = super.getRequestRouter();
            for (HttpRouter router : this.fRouters) {
                router.setupRouter(this, rr, p);
            }
            log.info("The server is ready.");
        }
        catch (Builder.BuildFailure | IOException e) {
            throw new ServletException(e);
        }
    }

    protected CHttpMetricNamer getMetricNamer() {
        return this.fMetricNamer == null ? super.getMetricNamer() : this.fMetricNamer;
    }
}

