/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.model.api.endpoints;

import io.continual.email.impl.SimpleEmailService;
import io.continual.http.service.framework.context.CHttpRequestContext;
import io.continual.iam.IamServiceManager;
import io.continual.iam.credentials.UsernamePasswordCredential;
import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.UserContext;
import io.continual.restHttp.ApiContextHelper;
import io.continual.restHttp.HttpServlet;
import io.continual.services.ServiceContainer;
import io.continual.util.nv.NvReadable;
import io.continual.util.time.Clock;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthApiHandler
extends ApiContextHelper<Identity> {
    private static final String kSetting_PwResetLink = "passwordResetLinkBase";
    private static final String kDefault_PwResetLink = "https://docs.cfgex.com/pwr";
    private final String fResetUrl;
    private static final Logger log = LoggerFactory.getLogger(AuthApiHandler.class);

    public AuthApiHandler(ServiceContainer sc, JSONObject config) {
        String baseUrlConfig = config.optString(kSetting_PwResetLink, kDefault_PwResetLink);
        String baseUrlEvaled = sc.getExprEval().evaluateText(baseUrlConfig);
        if (baseUrlEvaled == null || baseUrlEvaled.length() == 0) {
            log.warn("Password reset link config eval'd to an empty string. Using default.");
            baseUrlEvaled = kDefault_PwResetLink;
        }
        this.fResetUrl = sc.getExprEval().evaluateText(config.optString(kSetting_PwResetLink, kDefault_PwResetLink));
    }

    public AuthApiHandler(ServiceContainer sc, NvReadable config) {
        String baseUrlConfig = config.getString(kSetting_PwResetLink, kDefault_PwResetLink);
        String baseUrlEvaled = sc.getExprEval().evaluateText(baseUrlConfig);
        if (baseUrlEvaled == null || baseUrlEvaled.length() == 0) {
            log.warn("Password reset link config eval'd to an empty string. Using default.");
            baseUrlEvaled = kDefault_PwResetLink;
        }
        this.fResetUrl = sc.getExprEval().evaluateText(config.getString(kSetting_PwResetLink, kDefault_PwResetLink));
    }

    public void login(CHttpRequestContext context) throws IamSvcException, IOException {
        try {
            JSONObject body = AuthApiHandler.readBody((CHttpRequestContext)context);
            String username = body.getString("username");
            String password = body.getString("password");
            IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
            Identity ii = am.getIdentityDb().authenticate(new UsernamePasswordCredential(username, password));
            if (ii != null) {
                String token = am.getIdentityDb().createJwtToken(ii);
                AuthApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("status", (Object)"ok").put("token", (Object)token).put("username", (Object)username));
            } else {
                AuthApiHandler.sendJson((CHttpRequestContext)context, (int)401, (JSONObject)new JSONObject().put("message", (Object)"Unable to sign in."));
            }
        }
        catch (JSONException x) {
            AuthApiHandler.sendJson((CHttpRequestContext)context, (int)400, (JSONObject)new JSONObject().put("message", (Object)"There's a problem with your JSON."));
        }
    }

    public void logout(CHttpRequestContext context) throws IamSvcException, IOException {
        UserContext user = AuthApiHandler.getUser((CHttpRequestContext)context);
        if (user != null) {
            String[] parts;
            IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
            String authHeader = context.request().getFirstHeader("Authorization");
            if (authHeader != null && authHeader.startsWith("Bearer ") && (parts = authHeader.split(" ")).length == 2) {
                am.getIdentityDb().invalidateJwtToken(parts[1]);
            }
        }
    }

    public void changePassword(CHttpRequestContext context) throws IamSvcException, IOException {
        UserContext user = AuthApiHandler.getUser((CHttpRequestContext)context);
        if (user == null) {
            AuthApiHandler.sendNotAuth((CHttpRequestContext)context);
            return;
        }
        JSONObject body = AuthApiHandler.readBody((CHttpRequestContext)context);
        String username = user.getEffectiveUserId();
        String password = body.getString("currentPassword");
        String newPassword = body.getString("newPassword");
        IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
        Identity ii = am.getIdentityDb().authenticate(new UsernamePasswordCredential(username, password));
        if (ii == null) {
            AuthApiHandler.sendNotAuth((CHttpRequestContext)context);
            return;
        }
        ii.setPassword(newPassword);
        AuthApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("status", (Object)"ok"));
    }

    public void passwordResetProcess(CHttpRequestContext context) throws IOException {
        block7: {
            try {
                IamServiceManager am = (IamServiceManager)HttpServlet.getServices((CHttpRequestContext)context).get("accounts", IamServiceManager.class);
                SimpleEmailService emailSvc = (SimpleEmailService)HttpServlet.getServices((CHttpRequestContext)context).get("emailer", SimpleEmailService.class);
                JSONObject body = AuthApiHandler.readBody((CHttpRequestContext)context);
                String email = body.optString("email", null);
                String tag = body.optString("tag", null);
                String newPassword = body.optString("newPassword", null);
                if (email != null) {
                    Identity ii = am.getIdentityManager().loadUser(email);
                    if (ii != null) {
                        String newTag = ii.requestPasswordReset(86400L, "cfgex.docs.app." + Clock.now());
                        String msg = this.buildResetMsg(email, newTag);
                        emailSvc.mail(email, "Password reset instructions", msg);
                    }
                    break block7;
                }
                if (tag == null || newPassword == null) break block7;
                try {
                    if (!am.getIdentityManager().completePasswordReset(tag, newPassword)) {
                        AuthApiHandler.sendJson((CHttpRequestContext)context, (int)400, (JSONObject)new JSONObject().put("status", (Object)"error"));
                        return;
                    }
                }
                catch (IamSvcException x) {
                    AuthApiHandler.sendJson((CHttpRequestContext)context, (int)500, (JSONObject)new JSONObject().put("status", (Object)"error"));
                    return;
                }
            }
            catch (IamBadRequestException | IamSvcException x) {
                log.warn("starting password reset: " + x.getMessage());
            }
        }
        AuthApiHandler.sendJson((CHttpRequestContext)context, (JSONObject)new JSONObject().put("status", (Object)"ok"));
    }

    private String buildResetMsg(String email, String tag) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append("Hi-\n").append("\n").append("We received a request to reset the password for your account. If this was your request,\n").append("please click this link to continue: ").append(this.fResetUrl + "?tag=" + tag).append("\n").append("\n").append("Thanks!\n").append("\n");
        return sb.toString();
    }
}

