/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.model;

import io.continual.util.data.json.JsonEval;
import io.continual.util.data.json.JsonSerialized;
import io.continual.util.data.json.JsonUtil;
import org.json.JSONObject;

public class Message
implements JsonSerialized {
    private final JSONObject fData;

    public static Message copyJsonToMessage(JSONObject data) {
        return new Message(data, true);
    }

    public static Message adoptJsonAsMessage(JSONObject data) {
        return new Message(data, false);
    }

    public Message() {
        this(new JSONObject(), false);
    }

    protected Message(JSONObject msgData, boolean clone) {
        this.fData = clone ? JsonUtil.clone((JSONObject)msgData) : msgData;
    }

    public Message clone() {
        return new Message(this.accessRawJson(), true);
    }

    public String toString() {
        return this.toJson().toString(4);
    }

    public String toLine() {
        return this.toJson().toString();
    }

    public JSONObject toJson() {
        return JsonUtil.clone((JSONObject)this.fData);
    }

    public JSONObject accessRawJson() {
        return this.fData;
    }

    public boolean hasValue(String fieldName) {
        return this.fData.has(fieldName);
    }

    public String getValueAsString(String key) {
        return this.fData.optString(key, "");
    }

    public String evalExpression(String expression) {
        return JsonEval.evalToString((JSONObject)this.fData, (String)expression);
    }

    public boolean getBoolean(String field, boolean def) {
        return this.fData.optBoolean(field, def);
    }

    public int getInt(String field, int i) {
        return this.fData.optInt(field, i);
    }

    public long getLong(String field, long i) {
        return this.fData.optLong(field, i);
    }

    public double getDouble(String field, double i) {
        return this.fData.optDouble(field, i);
    }

    public Message putValue(String to, boolean val) {
        this.fData.put(to, val);
        return this;
    }

    public Message putValue(String to, double val) {
        this.fData.put(to, val);
        return this;
    }

    public Message putValue(String to, long val) {
        this.fData.put(to, val);
        return this;
    }

    public Message putValue(String to, String val) {
        this.fData.put(to, (Object)val);
        return this;
    }

    public Message putRawValue(String to, Object val) {
        this.fData.put(to, val);
        return this;
    }

    public Object getRawValue(String key) {
        return this.fData.opt(key);
    }

    public Message clearValue(String key) {
        this.fData.remove(key);
        return this;
    }
}

