/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.library.jdbcio;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import io.continual.builder.Builder;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.SQLException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbConnection {
    private final String fUrl;
    private final String fDbUser;
    private final String fDbPwd;
    private ComboPooledDataSource fDbPool;
    private static final Logger log = LoggerFactory.getLogger(DbConnection.class);

    public DbConnection(String url, String user, String pwd) throws Builder.BuildFailure {
        this(new JSONObject().put("url", (Object)url).put("dbUser", (Object)user).put("dbPwd", (Object)pwd));
    }

    public DbConnection(JSONObject config) throws Builder.BuildFailure {
        try {
            this.fUrl = config.getString("url");
            this.fDbUser = config.optString("dbUser", null);
            this.fDbPwd = config.optString("dbPwd", null);
            log.info("Creating DB connection using URL {}", (Object)this.fUrl);
            this.fDbPool = new ComboPooledDataSource();
            try {
                this.fDbPool.setDriverClass(config.optString("driver", "com.mysql.cj.jdbc.Driver"));
                this.fDbPool.setJdbcUrl(this.fUrl);
                if (this.fDbUser != null) {
                    this.fDbPool.setUser(this.fDbUser);
                }
                if (this.fDbPwd != null) {
                    this.fDbPool.setPassword(this.fDbPwd);
                }
                this.fDbPool.setMinPoolSize(config.optInt("minPoolSize", 1));
                this.fDbPool.setAcquireIncrement(config.optInt("acquireIncrement", 1));
                this.fDbPool.setMaxPoolSize(config.optInt("maxPoolSize", 16));
                this.fDbPool.setTestConnectionOnCheckout(true);
            }
            catch (PropertyVetoException e) {
                throw new RuntimeException(e);
            }
        }
        catch (JSONException x) {
            throw new Builder.BuildFailure((Throwable)x);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.fDbPool.getConnection();
    }
}

