/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.library.jdbcio.common;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.library.jdbcio.DbConnection;
import io.continual.util.data.exprEval.ExprDataSource;
import io.continual.util.data.exprEval.ExpressionEvaluator;
import org.json.JSONException;
import org.json.JSONObject;

public class DbConnector {
    private final DbConnection fDb;
    private final String fTable;

    public static DbConnection dbConnectionFromConfig(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        ExpressionEvaluator ee = sc != null ? sc.getServiceContainer().getExprEval(config) : new ExpressionEvaluator(new ExprDataSource[0]);
        String url = DbConnector.getValue(ee, config, new String[]{"dbUrl", "url"}, false);
        if (url == null || url.length() == 0) {
            String host = DbConnector.getValue(ee, config, new String[]{"dbHost", "host"}, true);
            String dbname = DbConnector.getValue(ee, config, new String[]{"dbName", "name"}, true);
            if (host == null || host.length() == 0) {
                throw new Builder.BuildFailure("Neither 'dbUrl' nor 'dbHost' has a value.");
            }
            if (dbname == null || dbname.length() == 0) {
                throw new Builder.BuildFailure("Neither 'dbUrl' nor 'dbName' has a value.");
            }
            url = "jdbc:mysql://" + host + "/" + dbname + "?serverTimezone=UTC&rewriteBatchedStatements=true&useSSL=false&autoReconnect=true";
        }
        String user = DbConnector.getValue(ee, config, new String[]{"dbUser", "user"}, false);
        String pwd = DbConnector.getValue(ee, config, new String[]{"dbPassword", "password"}, false);
        return new DbConnection(url, user, pwd);
    }

    public DbConnector(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(DbConnector.dbConnectionFromConfig(sc, config), sc, config);
    }

    public DbConnector(DbConnection dbsrc, ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        try {
            this.fDb = dbsrc;
            this.fTable = sc.getServiceContainer().getExprEval(config).evaluateText(config.optString("table", null));
        }
        catch (JSONException e) {
            throw new Builder.BuildFailure((Throwable)e);
        }
    }

    public DbConnection getDb() {
        return this.fDb;
    }

    public String getTable() {
        return this.fTable;
    }

    private static String getValue(ExpressionEvaluator ee, JSONObject config, String[] keys, boolean reqd) throws Builder.BuildFailure {
        for (String key : keys) {
            String val = config.optString(key, null);
            if (val == null) continue;
            return ee.evaluateText(val);
        }
        if (reqd) {
            throw new Builder.BuildFailure("Missing required setting for [" + keys[0] + "].");
        }
        return null;
    }
}

