/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.library.jdbcio.processors;

import io.continual.builder.Builder;
import io.continual.services.processor.config.readers.ConfigLoadContext;
import io.continual.services.processor.engine.model.MessageProcessingContext;
import io.continual.services.processor.engine.model.Processor;
import io.continual.services.processor.library.jdbcio.DbConnection;
import io.continual.services.processor.library.jdbcio.common.DbConnector;
import io.continual.util.collections.LruCache;
import io.continual.util.data.json.JsonUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.json.JSONObject;

public class JdbcLookup
extends DbConnector
implements Processor {
    private final String fLookupField;
    private final String fLookupValue;
    private final String fToField;
    private final boolean fCaching;
    private final LruCache<String, JSONObject> fCache;

    public JdbcLookup() throws Builder.BuildFailure {
        this(new JSONObject());
    }

    public JdbcLookup(JSONObject config) throws Builder.BuildFailure {
        this(null, config);
    }

    public JdbcLookup(ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        this(JdbcLookup.dbConnectionFromConfig(sc, config), sc, config);
    }

    public JdbcLookup(DbConnection dbsrc, ConfigLoadContext sc, JSONObject config) throws Builder.BuildFailure {
        super(dbsrc, sc, config);
        this.fLookupField = config.getString("lookupField");
        this.fLookupValue = config.getString("lookupValue");
        this.fToField = config.getString("toField");
        this.fCache = new LruCache(4096L);
        this.fCaching = config.optBoolean("cache", true);
    }

    public void process(MessageProcessingContext context) {
        try {
            JSONObject data;
            String lf = context.evalExpression(this.fLookupField);
            String lv = context.evalExpression(this.fLookupValue);
            if (this.fCaching && this.fCache.containsKey((Object)lv)) {
                data = (JSONObject)this.fCache.get((Object)lv);
            } else {
                try (Connection c = this.getDb().getConnection();){
                    PreparedStatement ps = c.prepareStatement("SELECT * FROM " + this.getTable() + " WHERE " + lf + "=?");
                    ps.setString(1, lv);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        data = new JSONObject();
                        ResultSetMetaData rsm = rs.getMetaData();
                        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
                            String label = rsm.getColumnName(i);
                            data.put(label, (Object)rs.getString(i));
                        }
                        this.fCache.put((Object)lv, (Object)data);
                        if (rs.next()) {
                            context.warn("Lookup for " + lf + "=" + lv + " returned more than one result.");
                        }
                    } else {
                        data = null;
                    }
                }
            }
            if (data != null) {
                context.getMessage().putRawValue(this.fToField, (Object)JsonUtil.clone((JSONObject)data));
            }
        }
        catch (SQLException e) {
            context.warn(e.getMessage());
        }
    }
}

