/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import io.craft.atom.protocol.AbstractProtocolCodec;
import io.craft.atom.protocol.ProtocolDecoder;
import io.craft.atom.protocol.ProtocolException;
import io.craft.atom.protocol.http.HttpDates;
import io.craft.atom.protocol.http.model.HttpCookie;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class HttpCookieDecoder
extends AbstractProtocolCodec
implements ProtocolDecoder<HttpCookie> {
    private static final int START = 0;
    private static final int NAME = 1;
    private static final int VALUE = 2;
    private static final int ATTRIBUTE_START = 3;
    private static final int ATTRIBUTE_NAME = 4;
    private static final int DOMAIN_ATTRIBUTE_VALUE = 5;
    private static final int PATH_ATTRIBUTE_VALUE = 6;
    private static final int EXPIRES_ATTRIBUTE_VALUE = 7;
    private static final int MAX_AGE_ATTRIBUTE_VALUE = 8;
    private static final int EXTENSION_ATTRIBUTE_VALUE = 9;
    private static final int END = -1;
    private boolean setCookie = false;

    public HttpCookieDecoder() {
    }

    public HttpCookieDecoder(Charset charset) {
        this.charset = charset;
    }

    public HttpCookieDecoder(Charset charset, boolean setCookie) {
        this.charset = charset;
        this.setCookie = setCookie;
    }

    public void reset() {
    }

    public List<HttpCookie> decode(byte[] bytes) throws ProtocolException {
        try {
            if (this.setCookie) {
                return this.decode4setCookie(bytes);
            }
            return this.decode4cookie(bytes);
        }
        catch (Exception e) {
            if (e instanceof ProtocolException) {
                throw (ProtocolException)e;
            }
            throw new ProtocolException((Throwable)e);
        }
    }

    private List<HttpCookie> decode4cookie(byte[] bytes) throws ProtocolException {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        HttpCookie cookie = null;
        int searchIndex = 0;
        int stateIndex = 0;
        int state = 0;
        int len = bytes.length;
        int i = 0;
        while (searchIndex < len) {
            switch (state) {
                case 0: {
                    while (searchIndex < len && bytes[searchIndex] == 32) {
                        ++searchIndex;
                    }
                    stateIndex = searchIndex;
                    state = 1;
                    cookie = new HttpCookie();
                    break;
                }
                case 1: {
                    while (searchIndex < len && bytes[searchIndex] != 61) {
                        ++searchIndex;
                        ++i;
                    }
                    String name = new String(bytes, stateIndex, i, this.charset);
                    cookie.setName(name);
                    stateIndex = ++searchIndex;
                    i = 0;
                    state = 2;
                    break;
                }
                case 2: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String value = new String(bytes, stateIndex, i, this.charset);
                    cookie.setValue(value);
                    cookies.add(cookie);
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 0;
                    break;
                }
            }
        }
        return cookies;
    }

    private List<HttpCookie> decode4setCookie(byte[] bytes) throws ProtocolException {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        HttpCookie cookie = null;
        int searchIndex = 0;
        int stateIndex = 0;
        int state = 0;
        int len = bytes.length;
        int i = 0;
        String extentionName = "";
        while (searchIndex < len) {
            switch (state) {
                case 0: {
                    while (searchIndex < len && bytes[searchIndex] == 32) {
                        ++searchIndex;
                    }
                    stateIndex = searchIndex;
                    state = 1;
                    cookie = new HttpCookie();
                    break;
                }
                case 1: {
                    while (searchIndex < len && bytes[searchIndex] != 61) {
                        ++searchIndex;
                        ++i;
                    }
                    String name = new String(bytes, stateIndex, i, this.charset);
                    cookie.setName(name);
                    stateIndex = ++searchIndex;
                    i = 0;
                    state = 2;
                    break;
                }
                case 2: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String value = new String(bytes, stateIndex, i, this.charset);
                    cookie.setValue(value);
                    cookies.add(cookie);
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 3: {
                    while (searchIndex < len && bytes[searchIndex] == 32) {
                        ++searchIndex;
                    }
                    stateIndex = searchIndex;
                    state = 4;
                    break;
                }
                case 4: {
                    while (searchIndex < len && bytes[searchIndex] != 61 && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String an = new String(bytes, stateIndex, i, this.charset);
                    if ("Domain".equalsIgnoreCase(an)) {
                        state = 5;
                    } else if ("Path".equalsIgnoreCase(an)) {
                        state = 6;
                    } else if ("HttpOnly".equalsIgnoreCase(an)) {
                        cookie.setHttpOnly(true);
                        state = searchIndex >= len ? -1 : 3;
                    } else if ("Secure".equalsIgnoreCase(an)) {
                        cookie.setSecure(true);
                        state = searchIndex >= len ? -1 : 3;
                    } else if ("Expires".equalsIgnoreCase(an)) {
                        state = 7;
                    } else if ("Max-Age".equalsIgnoreCase(an)) {
                        state = 8;
                    } else {
                        extentionName = an;
                        state = 9;
                    }
                    stateIndex = ++searchIndex;
                    i = 0;
                    break;
                }
                case 5: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String domain = new String(bytes, stateIndex, i, this.charset);
                    cookie.setDomain(domain);
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 6: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String path = new String(bytes, stateIndex, i, this.charset);
                    cookie.setPath(path);
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 7: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String expires = new String(bytes, stateIndex, i, this.charset);
                    cookie.setExpires(HttpDates.parse(expires));
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 8: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String maxAge = new String(bytes, stateIndex, i, this.charset);
                    cookie.setMaxAge(Integer.parseInt(maxAge));
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 3;
                    break;
                }
                case 9: {
                    while (searchIndex < len && bytes[searchIndex] != 59) {
                        ++searchIndex;
                        ++i;
                    }
                    String extentionValue = new String(bytes, stateIndex, i, this.charset);
                    cookie.addExtensionAttribute(extentionName, extentionValue);
                    stateIndex = ++searchIndex;
                    i = 0;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 3;
                    break;
                }
            }
        }
        return cookies;
    }

    public String toString() {
        return "HttpCookieDecoder(super=" + super.toString() + ", setCookie=" + this.setCookie + ")";
    }
}

