/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class HttpDates {
    private static final String DATE_FORMAT_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final ThreadLocal<DateFormat> threadLocal = new ThreadLocal();
    private static long dateAsLong = 0L;
    private static String dateAsText = null;

    private static DateFormat getDateFormat() {
        DateFormat df = threadLocal.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_FORMAT_RFC1123, Locale.US);
            df.setTimeZone(GMT);
            threadLocal.set(df);
        }
        return df;
    }

    public static String formatCurrentDate() {
        long now = System.currentTimeMillis();
        if (now - dateAsLong > 1000L) {
            dateAsText = HttpDates.format(new Date(now));
            dateAsLong = now;
        }
        return dateAsText;
    }

    public static String format(Date date) {
        DateFormat df = HttpDates.getDateFormat();
        return df.format(date);
    }

    public static Date parse(String dateString) {
        DateFormat df = HttpDates.getDateFormat();
        try {
            return df.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid date string format=" + dateString, e);
        }
    }
}

