/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import io.craft.atom.protocol.AbstractProtocolDecoder;
import io.craft.atom.protocol.ProtocolException;
import io.craft.atom.protocol.ProtocolExceptionType;
import io.craft.atom.protocol.http.model.HttpChunk;
import io.craft.atom.protocol.http.model.HttpChunkEntity;
import io.craft.atom.protocol.http.model.HttpContentType;
import io.craft.atom.protocol.http.model.HttpEntity;
import io.craft.atom.protocol.http.model.HttpHeader;
import io.craft.atom.protocol.http.model.HttpHeaderType;
import io.craft.atom.protocol.http.model.HttpHeaderValueElement;
import io.craft.atom.protocol.http.model.HttpMessage;
import io.craft.atom.protocol.http.model.MimeType;
import io.craft.atom.util.ByteUtil;
import io.craft.atom.util.GzipUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

public abstract class HttpDecoder<T extends HttpMessage>
extends AbstractProtocolDecoder {
    protected static final int METHOD = 11;
    protected static final int REQUEST_URI = 12;
    protected static final int STATUS_CODE = 21;
    protected static final int REASON_PHRASE = 22;
    protected static final int VERSION = 30;
    protected static final int HEADER_NAME = 40;
    protected static final int HEADER_VALUE_PREFIX = 41;
    protected static final int HEADER_VALUE = 42;
    protected static final int HEADER_VALUE_SUFFIX = 43;
    protected static final int ENTITY = 50;
    protected static final int ENTITY_LENGTH = 51;
    protected static final int ENTITY_CHUNKED_SIZE = 52;
    protected static final int ENTITY_CHUNKED_EXTENSION_NAME = 53;
    protected static final int ENTITY_CHUNKED_EXTENSION_VALUE = 54;
    protected static final int ENTITY_CHUNKED_DATA = 55;
    protected static final int ENTITY_CHUNKED_TRAILER_NAME = 56;
    protected static final int ENTITY_CHUNKED_TRAILER_VALUE = 57;
    protected static final int ENTITY_ENCODING = 58;
    protected int maxLineLength;
    protected int trailerSize;
    protected HttpHeader header;
    protected HttpEntity entity;
    protected HttpChunk chunk;
    protected HttpContentType contentType;
    protected String chunkExtName;
    protected T httpMessage;

    public HttpDecoder() {
        this.maxLineLength = this.defaultBufferSize;
    }

    public void reset() {
        super.reset();
        this.maxLineLength = this.defaultBufferSize;
        this.stateIndex = 0;
        this.state = 0;
        this.trailerSize = 0;
        this.header = null;
        this.entity = null;
        this.chunk = null;
        this.contentType = null;
        this.chunkExtName = null;
        this.httpMessage = null;
    }

    protected void state4END(List<T> httpMessages) throws ProtocolException {
        this.slide(1);
        httpMessages.add(this.httpMessage);
        this.splitIndex = this.stateIndex = this.searchIndex;
        this.clear();
        this.state = 0;
    }

    protected void state4ENTITY_ENCODING() throws ProtocolException, IOException {
        HttpHeader ceh = ((HttpMessage)this.httpMessage).getFirstHeader(HttpHeaderType.CONTENT_ENCODING.getName());
        String coding = null;
        coding = ceh == null ? "identity" : ceh.getValue();
        if (coding == null || "identity".equals(coding)) {
            ((HttpMessage)this.httpMessage).getEntity().setContent(((HttpMessage)this.httpMessage).getEntity().getContent());
        } else if ("gzip".equals(coding)) {
            byte[] content = GzipUtil.ungzip((byte[])((HttpMessage)this.httpMessage).getEntity().getContent());
            ((HttpMessage)this.httpMessage).getEntity().setContent(content);
        } else {
            if ("deflate".equals(coding)) {
                throw new ProtocolException(ProtocolExceptionType.UNEXPECTED, new Object[]{"unsupported content encoding=" + coding});
            }
            throw new ProtocolException(ProtocolExceptionType.UNEXPECTED, new Object[]{"unsupported content encoding=" + coding});
        }
        ((HttpMessage)this.httpMessage).setEntity(this.entity);
        this.state = -1;
    }

    protected void state4ENTITY_CHUNKED_TRAILER_NAME() throws ProtocolException {
        boolean done = this.skip(13, 10);
        if (!done) {
            return;
        }
        String name = this.sliceBySeparators(0, 58);
        if (name == null) {
            return;
        }
        this.header = new HttpHeader();
        this.header.setName(name);
        --this.trailerSize;
        this.state = 57;
    }

    protected void state4ENTITY_CHUNKED_TRAILER_VALUE() throws ProtocolException {
        boolean done = this.skip(32, 9);
        if (!done) {
            return;
        }
        String value = this.sliceBySeparators(-1, 10);
        if (value == null) {
            return;
        }
        this.header.appendValue(value);
        ((HttpChunkEntity)this.entity).addTrailer(this.header);
        if (this.trailerSize == 0) {
            this.slide(-1);
            this.state = -1;
        } else {
            this.state = 56;
        }
    }

    protected void state4ENTITY_CHUNKED_DATA() throws ProtocolException {
        boolean done = this.skip(13, 10);
        if (!done) {
            return;
        }
        int clen = this.chunk.getSize();
        byte[] chunkData = this.sliceByLength(clen);
        if (chunkData == null) {
            return;
        }
        this.chunk.setData(chunkData);
        ((HttpChunkEntity)this.entity).addChunk(this.chunk);
        this.slide(2);
        this.state = 52;
    }

    protected void state4ENTITY_CHUNKED_EXTENSION_VALUE() throws ProtocolException {
        String chunkExtValue = this.sliceBySeparators(0, 59, 13);
        if (chunkExtValue == null) {
            return;
        }
        this.chunk.addExtension(this.chunkExtName, chunkExtValue);
        byte pb = this.previousByte();
        this.state = 59 == pb ? 53 : 55;
    }

    protected void state4ENTITY_CHUNKED_EXTENSION_NAME() throws ProtocolException {
        String name = this.sliceBySeparators(0, 61, 13);
        if (name == null) {
            return;
        }
        this.chunkExtName = name;
        byte pb = this.previousByte();
        if (61 == pb) {
            this.state = 54;
        } else {
            this.chunk.addExtension(this.chunkExtName, null);
            this.state = 55;
        }
    }

    protected void state4ENTITY_CHUNKED_SIZE() throws ProtocolException {
        boolean done = this.skip(10);
        if (!done) {
            return;
        }
        String sizeStr = this.sliceBySeparators(0, 59, 13);
        if (sizeStr == null) {
            return;
        }
        int size = Integer.parseInt(sizeStr, 16);
        if (size < 0) {
            throw new ProtocolException(ProtocolExceptionType.UNEXPECTED, new Object[]{"chunked size < 0"});
        }
        this.chunk = new HttpChunk();
        this.chunk.setSize(size);
        byte pb = this.previousByte();
        if (59 == pb) {
            this.state = 53;
        } else if (size > 0) {
            this.state = 55;
        } else if (size == 0) {
            HttpHeader trailerHeader = ((HttpMessage)this.httpMessage).getFirstHeader(HttpHeaderType.TRAILER.getName());
            ((HttpMessage)this.httpMessage).setEntity(this.entity);
            if (trailerHeader != null) {
                this.trailerSize = trailerHeader.getValue().split(",").length;
                if (this.trailerSize <= 0) {
                    throw new ProtocolException(ProtocolExceptionType.UNEXPECTED, new Object[]{"trailer size ilegal=" + this.trailerSize});
                }
                this.state = 56;
            } else {
                this.state = 58;
            }
        }
    }

    protected void state4ENTITY_LENGTH() throws ProtocolException {
        int clen = Integer.parseInt(((HttpMessage)this.httpMessage).getFirstHeader(HttpHeaderType.CONTENT_LENGTH.getName()).getValue());
        if (clen < 0) {
            throw new ProtocolException(ProtocolExceptionType.UNEXPECTED, new Object[]{"content length < 0"});
        }
        byte[] content = this.sliceByLength(clen);
        if (content == null) {
            return;
        }
        this.entity.setContent(content);
        ((HttpMessage)this.httpMessage).setEntity(this.entity);
        this.state = 58;
    }

    protected void state4ENTITY() throws ProtocolException {
        boolean done = this.skip(13, 10);
        if (!done) {
            return;
        }
        if (((HttpMessage)this.httpMessage).getFirstHeader(HttpHeaderType.CONTENT_LENGTH.getName()) != null) {
            this.entity = new HttpEntity();
            this.entity.setContentType(this.getContentType((HttpMessage)this.httpMessage));
            this.state = 51;
        } else if ("chunked".equals(((HttpMessage)this.httpMessage).getFirstHeader(HttpHeaderType.TRANSFER_ENCODING.getName()).getValue())) {
            this.entity = new HttpChunkEntity();
            this.entity.setContentType(this.getContentType((HttpMessage)this.httpMessage));
            this.state = 52;
        } else {
            this.state = -1;
        }
    }

    protected void state4HEADER_VALUE_SUFFIX() throws ProtocolException {
        byte cb = this.currentByte();
        if (32 == cb || 9 == cb) {
            this.state = 41;
        } else if (13 == cb) {
            ((HttpMessage)this.httpMessage).addHeader(this.header);
            this.state = this.hasEntity(this.httpMessage) ? 50 : -1;
            this.slide(1);
        } else {
            ((HttpMessage)this.httpMessage).addHeader(this.header);
            this.state = 40;
        }
    }

    protected void state4HEADER_VALUE() throws ProtocolException {
        String value = this.sliceBySeparators(-1, 10);
        if (value == null) {
            return;
        }
        this.header.appendValue(value);
        byte cb = this.currentByte();
        if (0 == cb) {
            this.state = 43;
        } else if (32 == cb || 9 == cb) {
            this.state = 41;
        } else if (13 == cb) {
            ((HttpMessage)this.httpMessage).addHeader(this.header);
            this.state = this.hasEntity(this.httpMessage) ? 50 : -1;
            this.slide(1);
        } else {
            ((HttpMessage)this.httpMessage).addHeader(this.header);
            this.state = 40;
        }
    }

    protected void state4HEADER_VALUE_PREFIX() throws ProtocolException {
        boolean done = this.skip(32, 9);
        if (!done) {
            return;
        }
        this.state = 42;
    }

    protected void state4HEADER_NAME() throws ProtocolException {
        String name = this.sliceBySeparators(0, 58);
        if (name == null) {
            return;
        }
        this.header = new HttpHeader();
        this.header.setName(name);
        this.state = 41;
    }

    protected void adapt() {
        if (this.splitIndex > 0 && this.splitIndex < this.buf.length()) {
            byte[] tailBytes = this.buf.array(this.splitIndex, this.buf.length());
            this.buf.clear();
            this.buf.append(tailBytes);
            this.stateIndex -= this.splitIndex;
            this.searchIndex = this.buf.length();
            this.splitIndex = 0;
        }
        if (this.splitIndex > 0 && this.splitIndex == this.buf.length()) {
            this.buf.clear();
            this.searchIndex = 0;
            this.splitIndex = 0;
            this.stateIndex = 0;
        }
        if (this.buf.length() == 0 && this.buf.capacity() > this.maxSize * 2) {
            this.buf.reset(this.defaultBufferSize);
        }
    }

    protected HttpContentType getContentType(HttpMessage httpMessage) {
        if (this.contentType != null) {
            return this.contentType;
        }
        HttpHeader contentTypeHeader = httpMessage.getFirstHeader(HttpHeaderType.CONTENT_TYPE.getName());
        if (contentTypeHeader == null) {
            this.contentType = new HttpContentType(this.charset);
            return this.contentType;
        }
        List<HttpHeaderValueElement> elements = contentTypeHeader.getValueElements();
        if (elements.isEmpty()) {
            this.contentType = new HttpContentType(this.charset);
            return this.contentType;
        }
        HttpHeaderValueElement element = elements.get(0);
        Charset contentCharset = this.charset;
        String mimeType = element.getName();
        String charsetName = element.getParamValue("charset");
        if (charsetName != null) {
            contentCharset = Charset.forName(charsetName);
        }
        this.contentType = new HttpContentType(MimeType.from(mimeType), contentCharset);
        return this.contentType;
    }

    protected byte previousByte() {
        int i = this.searchIndex - 1;
        if (i < this.buf.length()) {
            return this.buf.byteAt(i);
        }
        return 0;
    }

    protected byte currentByte() {
        int i = this.searchIndex;
        if (i < this.buf.length()) {
            return this.buf.byteAt(i);
        }
        return 0;
    }

    protected byte nextByte() {
        int i = this.searchIndex + 1;
        if (i < this.buf.length()) {
            return this.buf.byteAt(i);
        }
        return 0;
    }

    protected byte[] sliceByLength(int len) throws ProtocolException {
        boolean done = false;
        int offset = this.stateIndex;
        int length = this.searchIndex - this.stateIndex;
        if (len < length) {
            throw new ProtocolException(ProtocolExceptionType.UNEXPECTED, new Object[]{"slice len=" + len + "< length=" + length});
        }
        int tailIndex = offset + len - 1;
        if (tailIndex < this.buf.length()) {
            this.stateIndex = this.searchIndex = tailIndex;
            done = true;
        } else {
            this.searchIndex = this.buf.length();
        }
        if (this.searchIndex > this.maxSize) {
            throw new ProtocolException(ProtocolExceptionType.MAX_SIZE_LIMIT, new Object[]{this.maxSize});
        }
        if (done) {
            byte[] bytes = new byte[len];
            System.arraycopy(this.buf.buffer(), offset, bytes, 0, len);
            return bytes;
        }
        return null;
    }

    protected String sliceBySeparators(int shift, byte ... separators) throws ProtocolException {
        boolean done = false;
        int offset = this.stateIndex;
        int length = this.searchIndex - this.stateIndex;
        int i = this.searchIndex;
        while (i < this.buf.length()) {
            if (length > this.maxLineLength) {
                throw new ProtocolException(ProtocolExceptionType.LINE_LENGTH_LIMIT, new Object[]{this.maxLineLength});
            }
            byte b = this.buf.byteAt(i);
            this.searchIndex = ++i;
            if (ByteUtil.indexOf((byte[])separators, (byte)b) >= 0) {
                length = this.searchIndex - this.stateIndex - 1;
                this.stateIndex = this.searchIndex;
                done = true;
                break;
            }
            ++length;
        }
        if (this.searchIndex > this.maxSize) {
            throw new ProtocolException(ProtocolExceptionType.MAX_SIZE_LIMIT, new Object[]{this.maxSize});
        }
        if (done) {
            return new String(this.buf.buffer(), offset, length + shift, this.charset);
        }
        return null;
    }

    protected boolean skip(byte ... bytes) throws ProtocolException {
        boolean done = false;
        int length = this.searchIndex - this.stateIndex;
        while (this.searchIndex < this.buf.length()) {
            byte cb = this.currentByte();
            if (ByteUtil.indexOf((byte[])bytes, (byte)cb) < 0 && 0 != cb) {
                done = true;
                break;
            }
            this.slide(1);
            if (++length <= this.maxSize) continue;
            throw new ProtocolException(ProtocolExceptionType.MAX_SIZE_LIMIT, new Object[]{this.maxSize});
        }
        return done;
    }

    protected void slide(int shift) throws ProtocolException {
        this.stateIndex = this.searchIndex += shift;
        if (this.searchIndex > this.maxSize) {
            throw new ProtocolException(ProtocolExceptionType.MAX_SIZE_LIMIT, new Object[]{this.maxSize});
        }
    }

    protected void clear() {
        this.header = null;
        this.entity = null;
        this.chunk = null;
        this.chunkExtName = null;
        this.trailerSize = 0;
        this.httpMessage = null;
    }

    protected void resetIndex() {
        this.stateIndex = 0;
        this.splitIndex = 0;
        this.searchIndex = 0;
    }

    abstract boolean hasEntity(T var1);

    public String toString() {
        return "HttpDecoder(super=" + super.toString() + ", maxLineLength=" + this.getMaxLineLength() + ", trailerSize=" + this.getTrailerSize() + ", header=" + this.getHeader() + ", entity=" + this.getEntity() + ", chunk=" + this.getChunk() + ", contentType=" + this.getContentType() + ", chunkExtName=" + this.getChunkExtName() + ", httpMessage=" + this.getHttpMessage() + ")";
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public int getTrailerSize() {
        return this.trailerSize;
    }

    public HttpHeader getHeader() {
        return this.header;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public HttpChunk getChunk() {
        return this.chunk;
    }

    public HttpContentType getContentType() {
        return this.contentType;
    }

    public String getChunkExtName() {
        return this.chunkExtName;
    }

    public T getHttpMessage() {
        return this.httpMessage;
    }
}

