/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import io.craft.atom.protocol.http.HttpDates;
import io.craft.atom.protocol.http.model.HttpContentType;
import io.craft.atom.protocol.http.model.HttpCookie;
import io.craft.atom.protocol.http.model.HttpHeader;
import io.craft.atom.protocol.http.model.HttpHeaderType;

public class HttpHeaders {
    public static HttpHeader newServerHeader(String serverName) {
        return new HttpHeader(HttpHeaderType.SERVER.getName(), serverName);
    }

    public static HttpHeader newConnectionHeader(boolean keepAlive) {
        if (keepAlive) {
            return new HttpHeader(HttpHeaderType.CONNECTION.getName(), "Keep-alive");
        }
        return new HttpHeader(HttpHeaderType.CONNECTION.getName(), "close");
    }

    public static HttpHeader newDateHeader() {
        return new HttpHeader(HttpHeaderType.DATE.getName(), HttpDates.formatCurrentDate());
    }

    public static HttpHeader newContentLengthHeader(int length) {
        return new HttpHeader(HttpHeaderType.CONTENT_LENGTH.getName(), Integer.toString(length));
    }

    public static HttpHeader newContentTypeHeader(HttpContentType contentType) {
        if (contentType == null) {
            return null;
        }
        return new HttpHeader(HttpHeaderType.CONTENT_TYPE.getName(), contentType.toHttpString());
    }

    public static HttpHeader newKeepAliveHeader(String options) {
        return new HttpHeader(HttpHeaderType.KEEP_ALIVE.getName(), options);
    }

    public static HttpHeader newCookieHeader(HttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        return new HttpHeader(HttpHeaderType.COOKIE.getName(), cookie.toHttpString());
    }

    public static HttpHeader newSetCookieHeader(HttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        return new HttpHeader(HttpHeaderType.SET_COOKIE.getName(), cookie.toHttpString());
    }
}

