/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import io.craft.atom.protocol.AbstractProtocolCodec;
import io.craft.atom.protocol.ProtocolDecoder;
import io.craft.atom.protocol.ProtocolException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpParameterDecoder
extends AbstractProtocolCodec
implements ProtocolDecoder<Map<String, List<String>>> {
    private static final int START = 0;
    private static final int NAME = 1;
    private static final int VALUE = 2;
    private static final int END = -1;

    public HttpParameterDecoder() {
    }

    public HttpParameterDecoder(Charset charset) {
        this.charset = charset;
    }

    public void reset() {
    }

    public List<Map<String, List<String>>> decode(byte[] bytes) throws ProtocolException {
        try {
            return this.decode0(bytes);
        }
        catch (Exception e) {
            if (e instanceof ProtocolException) {
                throw (ProtocolException)e;
            }
            throw new ProtocolException((Throwable)e);
        }
    }

    private List<Map<String, List<String>>> decode0(byte[] bytes) throws ProtocolException, UnsupportedEncodingException {
        ArrayList<Map<String, List<String>>> paras = new ArrayList<Map<String, List<String>>>();
        HashMap<String, ArrayList<String>> map = null;
        String name = null;
        String value = null;
        int searchIndex = 0;
        int stateIndex = 0;
        int state = 0;
        int len = bytes.length;
        int i = 0;
        boolean decode = false;
        while (searchIndex < len) {
            switch (state) {
                case 0: {
                    state = 1;
                    map = new HashMap<String, ArrayList<String>>();
                    break;
                }
                case 1: {
                    byte nameHead = bytes[searchIndex];
                    if (nameHead == 43 || nameHead == 37) {
                        decode = true;
                    }
                    while (searchIndex < len && bytes[searchIndex] != 61) {
                        ++searchIndex;
                        ++i;
                    }
                    name = new String(bytes, stateIndex, i, this.charset);
                    if (decode) {
                        name = URLDecoder.decode(name, this.charset.name());
                    }
                    stateIndex = ++searchIndex;
                    i = 0;
                    decode = false;
                    state = 2;
                    break;
                }
                case 2: {
                    ArrayList<String> values;
                    byte valueHead = bytes[searchIndex];
                    if (valueHead == 43 || valueHead == 37) {
                        decode = true;
                    }
                    while (searchIndex < len && bytes[searchIndex] != 38) {
                        ++searchIndex;
                        ++i;
                    }
                    value = new String(bytes, stateIndex, i, this.charset);
                    if (decode) {
                        value = URLDecoder.decode(value, this.charset.name());
                    }
                    if ((values = (ArrayList<String>)map.get(name)) == null) {
                        values = new ArrayList<String>();
                        map.put(name, values);
                    }
                    values.add(value);
                    value = null;
                    name = null;
                    stateIndex = ++searchIndex;
                    i = 0;
                    decode = false;
                    if (searchIndex >= len) {
                        state = -1;
                        break;
                    }
                    state = 1;
                    break;
                }
            }
        }
        if (map != null) {
            paras.add(map);
        }
        return paras;
    }

    public String toString() {
        return "HttpParameterDecoder(super=" + super.toString() + ")";
    }
}

