/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import io.craft.atom.protocol.AbstractProtocolCodec;
import io.craft.atom.protocol.ProtocolEncoder;
import io.craft.atom.protocol.ProtocolException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpParameterEncoder
extends AbstractProtocolCodec
implements ProtocolEncoder<Map<String, List<String>>> {
    public HttpParameterEncoder() {
    }

    public HttpParameterEncoder(Charset charset) {
        this.charset = charset;
    }

    public byte[] encode(Map<String, List<String>> paras) throws ProtocolException {
        if (paras == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        Set<Map.Entry<String, List<String>>> entrys = paras.entrySet();
        for (Map.Entry<String, List<String>> entry : entrys) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                try {
                    name = URLEncoder.encode(name, this.charset.name());
                    value = URLEncoder.encode(value, this.charset.name());
                    buf.append(name).append("=").append(value).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    throw new ProtocolException((Throwable)e);
                }
            }
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString().getBytes(this.charset);
    }

    public String toString() {
        return "HttpParameterEncoder(super=" + super.toString() + ")";
    }
}

