/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http;

import io.craft.atom.protocol.ProtocolDecoder;
import io.craft.atom.protocol.ProtocolException;
import io.craft.atom.protocol.http.HttpDecoder;
import io.craft.atom.protocol.http.model.HttpMethod;
import io.craft.atom.protocol.http.model.HttpRequest;
import io.craft.atom.protocol.http.model.HttpVersion;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class HttpRequestDecoder
extends HttpDecoder<HttpRequest>
implements ProtocolDecoder<HttpRequest> {
    public HttpRequestDecoder() {
    }

    public HttpRequestDecoder(Charset charset) {
        this.charset = charset;
    }

    public HttpRequestDecoder(Charset charset, int defaultBufferSize) {
        this(charset);
        this.defaultBufferSize = defaultBufferSize;
        this.buf.reset(defaultBufferSize);
    }

    public HttpRequestDecoder(Charset charset, int defaultBufferSize, int maxLineLength) {
        this(charset, defaultBufferSize);
        this.maxLineLength = maxLineLength;
    }

    public HttpRequestDecoder(Charset charset, int defaultBufferSize, int maxLineLength, int maxRequestSize) {
        this(charset, defaultBufferSize, maxLineLength);
        this.maxSize = maxRequestSize;
    }

    public List<HttpRequest> decode(byte[] bytes) throws ProtocolException {
        try {
            return this.decode0(bytes);
        }
        catch (Exception e) {
            this.clear();
            this.resetIndex();
            if (e instanceof ProtocolException) {
                throw (ProtocolException)e;
            }
            throw new ProtocolException((Throwable)e);
        }
    }

    @Override
    protected boolean hasEntity(HttpRequest request) {
        HttpMethod method = request.getRequestLine().getMethod();
        return method == HttpMethod.POST || method == HttpMethod.PUT;
    }

    private List<HttpRequest> decode0(byte[] bytes) throws ProtocolException, IOException {
        ArrayList<HttpRequest> reqs = new ArrayList<HttpRequest>();
        this.adapt();
        this.buf.append(bytes);
        block20: while (this.searchIndex < this.buf.length()) {
            switch (this.state) {
                case 0: {
                    this.state4START();
                    continue block20;
                }
                case 11: {
                    this.state4METHOD();
                    continue block20;
                }
                case 12: {
                    this.state4REQUEST_URI();
                    continue block20;
                }
                case 30: {
                    this.state4VERSION();
                    continue block20;
                }
                case 40: {
                    this.state4HEADER_NAME();
                    continue block20;
                }
                case 41: {
                    this.state4HEADER_VALUE_PREFIX();
                    continue block20;
                }
                case 42: {
                    this.state4HEADER_VALUE();
                    continue block20;
                }
                case 43: {
                    this.state4HEADER_VALUE_SUFFIX();
                    continue block20;
                }
                case 50: {
                    this.state4ENTITY();
                    continue block20;
                }
                case 51: {
                    this.state4ENTITY_LENGTH();
                    continue block20;
                }
                case 52: {
                    this.state4ENTITY_CHUNKED_SIZE();
                    continue block20;
                }
                case 53: {
                    this.state4ENTITY_CHUNKED_EXTENSION_NAME();
                    continue block20;
                }
                case 54: {
                    this.state4ENTITY_CHUNKED_EXTENSION_VALUE();
                    continue block20;
                }
                case 55: {
                    this.state4ENTITY_CHUNKED_DATA();
                    continue block20;
                }
                case 56: {
                    this.state4ENTITY_CHUNKED_TRAILER_NAME();
                    continue block20;
                }
                case 57: {
                    this.state4ENTITY_CHUNKED_TRAILER_VALUE();
                    continue block20;
                }
                case 58: {
                    this.state4ENTITY_ENCODING();
                    continue block20;
                }
                case -1: {
                    this.state4END(reqs);
                    continue block20;
                }
            }
            throw new IllegalStateException("Invalid decoder state!");
        }
        return reqs;
    }

    private void state4VERSION() throws ProtocolException {
        String versionStr = this.sliceBySeparators(-1, 10);
        if (versionStr == null) {
            return;
        }
        HttpVersion version = HttpVersion.from(versionStr);
        ((HttpRequest)this.httpMessage).getRequestLine().setVersion(version);
        if (13 == this.currentByte() && 10 == this.nextByte()) {
            this.state = 50;
            this.slide(2);
        } else {
            this.state = 40;
        }
    }

    private void state4REQUEST_URI() throws ProtocolException {
        String uri = this.sliceBySeparators(0, 32, 9);
        if (uri == null) {
            return;
        }
        ((HttpRequest)this.httpMessage).getRequestLine().setUri(uri);
        this.state = 30;
    }

    private void state4METHOD() throws ProtocolException {
        String methodStr = this.sliceBySeparators(0, 32, 9);
        if (methodStr == null) {
            return;
        }
        HttpMethod method = HttpMethod.valueOf(methodStr);
        ((HttpRequest)this.httpMessage).getRequestLine().setMethod(method);
        this.state = 12;
    }

    private void state4START() throws ProtocolException {
        boolean done = this.skip(13, 10);
        if (!done) {
            return;
        }
        this.httpMessage = new HttpRequest();
        this.state = 11;
    }

    @Override
    public String toString() {
        return "HttpRequestDecoder(super=" + super.toString() + ")";
    }
}

