/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class HttpChunk
implements Serializable {
    private static final long serialVersionUID = 8782130672644634878L;
    private int size;
    private Map<String, String> extension = new LinkedHashMap<String, String>();
    private byte[] data;

    public HttpChunk() {
    }

    public HttpChunk(int size) {
        this.size = size;
    }

    public HttpChunk(int size, byte[] data) {
        this(size);
        this.data = data;
    }

    public HttpChunk(int size, String data, Charset charset) {
        this(size);
        this.data = data.getBytes(charset);
    }

    public HttpChunk(int size, byte[] data, Map<String, String> extension) {
        this(size, data);
        this.extension = extension;
    }

    public HttpChunk(int size, String data, Charset charset, Map<String, String> extension) {
        this(size, data, charset);
        this.extension = extension;
    }

    public String getDataString(Charset charset) {
        return new String(this.data, charset);
    }

    public void addExtension(String name, String value) {
        this.extension.put(name, value);
    }

    public String toHttpString(Charset charset) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toHexString(this.size));
        Set<Map.Entry<String, String>> extSet = this.extension.entrySet();
        for (Map.Entry<String, String> entry : extSet) {
            sb.append(";");
            String extName = entry.getKey();
            String extValue = entry.getValue();
            sb.append(extName);
            if (extValue == null) continue;
            sb.append("=").append(extValue);
        }
        sb.append("\r").append("\n");
        if (this.data != null) {
            sb.append(new String(this.data, charset)).append("\r").append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return "HttpChunk(size=" + this.getSize() + ", extension=" + this.getExtension() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Map<String, String> getExtension() {
        return this.extension;
    }

    public void setExtension(Map<String, String> extension) {
        this.extension = extension;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

