/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.http.model.HttpChunk;
import io.craft.atom.protocol.http.model.HttpEntity;
import io.craft.atom.protocol.http.model.HttpHeader;
import io.craft.atom.util.ByteArrayBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class HttpChunkEntity
extends HttpEntity {
    private static final long serialVersionUID = -8469016024998851045L;
    private List<HttpChunk> chunks = new ArrayList<HttpChunk>();
    private Map<String, HttpHeader> trailers = new LinkedHashMap<String, HttpHeader>();

    public HttpChunkEntity() {
    }

    public HttpChunkEntity(byte[] content) {
        super(content);
    }

    public HttpChunkEntity(List<HttpChunk> chunks) {
        this.chunks = chunks;
    }

    public HttpChunkEntity(List<HttpChunk> chunks, Map<String, HttpHeader> trailers) {
        this(chunks);
        this.trailers = trailers;
    }

    public void addChunk(HttpChunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTrailer(HttpHeader trailer) {
        if (trailer == null || trailer.getName() == null) {
            throw new IllegalArgumentException("trailer or trailer name is null!");
        }
        this.trailers.put(trailer.getName(), trailer);
    }

    @Override
    public byte[] getContent() {
        if (this.content == null) {
            ByteArrayBuffer buf = new ByteArrayBuffer();
            for (HttpChunk chunk : this.chunks) {
                buf.append(chunk.getData());
            }
            this.content = buf.array();
        }
        return this.content;
    }

    @Override
    public String toHttpString() {
        StringBuilder sb = new StringBuilder();
        for (HttpChunk chunk : this.getChunks()) {
            sb.append(chunk.toHttpString(this.contentType.getCharset()));
        }
        for (HttpHeader trailer : this.trailers.values()) {
            sb.append(trailer.toHttpString());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return "HttpChunkEntity(super=" + super.toString() + ", chunks=" + this.getChunks() + ", trailers=" + this.getTrailers() + ")";
    }

    public List<HttpChunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(List<HttpChunk> chunks) {
        this.chunks = chunks;
    }

    public Map<String, HttpHeader> getTrailers() {
        return this.trailers;
    }

    public void setTrailers(Map<String, HttpHeader> trailers) {
        this.trailers = trailers;
    }
}

