/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.http.model.MimeType;
import java.io.Serializable;
import java.nio.charset.Charset;

public class HttpContentType
implements Serializable {
    private static final long serialVersionUID = -7286615457150709389L;
    public static final HttpContentType DEFAULT = new HttpContentType(MimeType.TEXT_HTML, Charset.forName("utf-8"));
    private final MimeType mimeType;
    private final Charset charset;

    public HttpContentType(Charset charset) {
        this(null, charset);
    }

    public HttpContentType(MimeType mimeType) {
        this(mimeType, null);
    }

    public HttpContentType(MimeType mimeType, Charset charset) {
        this.mimeType = mimeType;
        this.charset = charset;
    }

    public String toHttpString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.mimeType.toString());
        if (this.charset != null) {
            buf.append("; charset=");
            buf.append(this.charset.name());
        }
        return buf.toString();
    }

    public String toString() {
        return "HttpContentType(mimeType=" + (Object)((Object)this.getMimeType()) + ", charset=" + this.getCharset() + ")";
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

