/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.http.HttpDates;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class HttpCookie
implements Serializable {
    private static final long serialVersionUID = 5584804359930330729L;
    public static final String DOMAIN = "Domain";
    public static final String PATH = "Path";
    public static final String HTTP_ONLY = "HttpOnly";
    public static final String SECURE = "Secure";
    public static final String EXPIRES = "Expires";
    public static final String MAX_AGE = "Max-Age";
    private String name;
    private String value;
    private String domain;
    private String path;
    private Boolean httpOnly;
    private Boolean secure;
    private Date expires;
    private Integer maxAge;
    private Map<String, String> extension = new LinkedHashMap<String, String>();

    public HttpCookie() {
    }

    public HttpCookie(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("Name should not be null");
        }
        this.name = name;
        this.value = value;
    }

    public HttpCookie(String name, String value, String domain) {
        this(name, value);
        this.domain = domain;
    }

    public HttpCookie(String name, String value, String domain, String path) {
        this(name, value, domain);
        this.path = path;
    }

    public HttpCookie(String name, String value, String domain, String path, boolean httpOnly) {
        this(name, value, domain, path);
    }

    public HttpCookie(String name, String value, String domain, String path, boolean httpOnly, int maxAge) {
        this(name, value, domain, path, httpOnly);
        this.maxAge = maxAge;
    }

    public Boolean isSecure() {
        return this.secure;
    }

    public Boolean isHttpOnly() {
        return this.httpOnly;
    }

    public Map<String, String> getExtensionAttributes() {
        return Collections.unmodifiableMap(this.extension);
    }

    public void addExtensionAttribute(String name, String value) {
        this.extension.put(name, value);
    }

    public void removeExtensionAttribute(String name) {
        this.extension.remove(name);
    }

    public String getExtensionAttribute(String name) {
        return this.extension.get(name);
    }

    public String toHttpString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append("=").append(this.getValue());
        if (this.domain != null) {
            sb.append(";").append(" ").append(DOMAIN).append("=").append(this.getDomain());
        }
        if (this.path != null) {
            sb.append(";").append(" ").append(PATH).append("=").append(this.getPath());
        }
        if (this.httpOnly != null) {
            sb.append(";").append(" ").append(HTTP_ONLY);
        }
        if (this.secure != null) {
            sb.append(";").append(" ").append(SECURE);
        }
        if (this.expires != null) {
            sb.append(";").append(" ").append(EXPIRES).append("=").append(HttpDates.format(this.getExpires()));
        }
        if (this.maxAge != null) {
            sb.append(";").append(" ").append(MAX_AGE).append("=").append(this.getMaxAge());
        }
        Set<Map.Entry<String, String>> entrys = this.extension.entrySet();
        for (Map.Entry<String, String> entry : entrys) {
            String k = entry.getKey();
            String v = entry.getValue();
            sb.append(";").append(" ").append(k);
            if (v == null) continue;
            sb.append("=").append(v);
        }
        return sb.toString();
    }

    public String toString() {
        return "HttpCookie(name=" + this.getName() + ", value=" + this.getValue() + ", domain=" + this.getDomain() + ", path=" + this.getPath() + ", httpOnly=" + this.httpOnly + ", secure=" + this.secure + ", expires=" + this.getExpires() + ", maxAge=" + this.getMaxAge() + ", extension=" + this.extension + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHttpOnly(Boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }
}

