/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.http.model.HttpContentType;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;

public class HttpEntity
implements Serializable {
    private static final long serialVersionUID = -3461343279665456788L;
    protected HttpContentType contentType = HttpContentType.DEFAULT;
    protected byte[] content;

    public HttpEntity() {
    }

    public HttpEntity(byte[] content) {
        this.content = content;
    }

    public HttpEntity(String content, HttpContentType contentType) {
        this.contentType = contentType;
        Charset charset = contentType.getCharset();
        this.content = content.getBytes(charset == null ? Charset.defaultCharset() : charset);
    }

    public String getContentAsString() {
        Charset charset = this.contentType.getCharset();
        return new String(this.content, charset == null ? Charset.defaultCharset() : charset);
    }

    public String toHttpString() {
        Charset charset = this.contentType.getCharset();
        return new String(this.content, charset == null ? Charset.defaultCharset() : charset);
    }

    public String toString() {
        return "HttpEntity(contentType=" + this.getContentType() + ", content=" + Arrays.toString(this.getContent()) + ")";
    }

    public HttpContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(HttpContentType contentType) {
        this.contentType = contentType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }
}

