/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.http.model.HttpHeaderValueElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class HttpHeader
implements Serializable {
    private static final long serialVersionUID = -689954816191532018L;
    private String name;
    private String value;

    public HttpHeader() {
    }

    public HttpHeader(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public void appendValue(String valuePart) {
        this.value = this.value == null ? valuePart : this.value + valuePart;
    }

    public List<HttpHeaderValueElement> getValueElements() {
        String[] earr;
        ArrayList<HttpHeaderValueElement> elements = new ArrayList<HttpHeaderValueElement>();
        if (this.value == null || this.value.length() == 0) {
            return elements;
        }
        for (String es : earr = this.value.split(",")) {
            HttpHeaderValueElement hve = new HttpHeaderValueElement();
            String[] nvs = es.split(";");
            this.parseNameValue(hve, nvs[0]);
            for (int i = 1; i < nvs.length; ++i) {
                this.parseParams(hve, nvs[i]);
            }
            elements.add(hve);
        }
        return elements;
    }

    private void parseParams(HttpHeaderValueElement hve, String pnv) {
        String[] nvpair = pnv.split("=");
        if (nvpair.length > 1) {
            hve.addParam(nvpair[0], nvpair[1]);
        } else {
            hve.addParam(nvpair[0], null);
        }
    }

    private void parseNameValue(HttpHeaderValueElement hve, String nv) {
        String[] nvpair = nv.split("=");
        hve.setName(nvpair[0]);
        if (nvpair.length > 1) {
            hve.setValue(nvpair[1]);
        }
    }

    public String toHttpString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":").append(" ").append(this.getValue()).append("\r").append("\n");
        return sb.toString();
    }

    public String toString() {
        return "HttpHeader(name=" + this.getName() + ", value=" + this.getValue() + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

