/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.http.model.HttpChunkEntity;
import io.craft.atom.protocol.http.model.HttpContentType;
import io.craft.atom.protocol.http.model.HttpCookie;
import io.craft.atom.protocol.http.model.HttpEntity;
import io.craft.atom.protocol.http.model.HttpHeader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class HttpMessage
implements Serializable {
    private static final long serialVersionUID = -8373186983205172162L;
    protected List<HttpHeader> headers = new ArrayList<HttpHeader>();
    protected HttpEntity entity;
    protected List<HttpCookie> cookies;

    public HttpMessage() {
    }

    public HttpMessage(List<HttpHeader> headers) {
        this.headers = headers;
    }

    public HttpMessage(List<HttpHeader> headers, HttpEntity entity) {
        this.headers = headers;
        this.entity = entity;
    }

    public void addHeader(HttpHeader header) {
        if (header == null || header.getName() == null) {
            return;
        }
        this.headers.add(header);
    }

    public void removeFirstHeader(String name) {
        this.removeHeaders0(name, true);
    }

    public void removeHeaders(String name) {
        this.removeHeaders0(name, false);
    }

    private void removeHeaders0(String name, boolean interrupt) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            HttpHeader header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            this.headers.remove(i);
            if (interrupt) break;
        }
    }

    public HttpHeader getFirstHeader(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.headers.size(); ++i) {
            HttpHeader header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public List<HttpHeader> getHeaders(String name) {
        ArrayList<HttpHeader> headersFound = new ArrayList<HttpHeader>();
        for (int i = 0; i < this.headers.size(); ++i) {
            HttpHeader header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            headersFound.add(header);
        }
        return headersFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HttpCookie> getCookies() {
        if (this.cookies != null) {
            return Collections.unmodifiableList(this.cookies);
        }
        HttpMessage httpMessage = this;
        synchronized (httpMessage) {
            if (this.cookies != null) {
                return Collections.unmodifiableList(this.cookies);
            }
            return Collections.unmodifiableList(this.parseCookies());
        }
    }

    public List<HttpCookie> getCookies(String name) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (name == null) {
            return cookies;
        }
        List<HttpCookie> allCookies = this.getCookies();
        for (HttpCookie cookie : allCookies) {
            if (!name.equalsIgnoreCase(cookie.getName())) continue;
            cookies.add(cookie);
        }
        return cookies;
    }

    public HttpCookie getCookie(String name) {
        List<HttpCookie> cookies = this.getCookies(name);
        if (cookies.isEmpty()) {
            return null;
        }
        return cookies.get(0);
    }

    public abstract void addCookie(HttpCookie var1);

    protected abstract List<HttpCookie> parseCookies();

    public HttpContentType getContentType() {
        HttpEntity entity = this.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getContentType();
    }

    public Iterator<HttpHeader> headerIterator() {
        return this.headers.iterator();
    }

    public String toHttpString(Charset charset) {
        HttpEntity entity;
        StringBuilder sb = new StringBuilder();
        Iterator<HttpHeader> it = this.headerIterator();
        boolean hasHeader = false;
        while (it.hasNext()) {
            HttpHeader header = it.next();
            sb.append(header.toHttpString());
            if (hasHeader) continue;
            hasHeader = true;
        }
        if (hasHeader) {
            sb.append("\r").append("\n");
        }
        if ((entity = this.getEntity()) != null) {
            if (entity instanceof HttpChunkEntity) {
                HttpChunkEntity chunkEntity = (HttpChunkEntity)entity;
                sb.append(chunkEntity.toHttpString());
            } else {
                sb.append(entity.toHttpString());
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "HttpMessage(headers=" + this.getHeaders() + ", entity=" + this.getEntity() + ", cookies=" + this.getCookies() + ")";
    }

    public List<HttpHeader> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<HttpHeader> headers) {
        this.headers = headers;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public void setCookies(List<HttpCookie> cookies) {
        this.cookies = cookies;
    }
}

