/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.ProtocolException;
import io.craft.atom.protocol.http.HttpCookieDecoder;
import io.craft.atom.protocol.http.HttpHeaders;
import io.craft.atom.protocol.http.HttpParameterDecoder;
import io.craft.atom.protocol.http.model.HttpContentType;
import io.craft.atom.protocol.http.model.HttpCookie;
import io.craft.atom.protocol.http.model.HttpEntity;
import io.craft.atom.protocol.http.model.HttpHeader;
import io.craft.atom.protocol.http.model.HttpHeaderType;
import io.craft.atom.protocol.http.model.HttpMessage;
import io.craft.atom.protocol.http.model.HttpRequestLine;
import io.craft.atom.protocol.http.model.MimeType;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
extends HttpMessage {
    private static final long serialVersionUID = 2454619732646455653L;
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequest.class);
    private static final HttpCookieDecoder COOKIE_DECODER = new HttpCookieDecoder();
    private static final HttpParameterDecoder PARAMETER_DECODER = new HttpParameterDecoder();
    private HttpRequestLine requestLine = new HttpRequestLine();
    private Map<String, List<String>> parameterMap;

    public HttpRequest() {
    }

    public HttpRequest(HttpRequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public HttpRequest(HttpRequestLine requestLine, List<HttpHeader> headers) {
        super(headers);
        this.requestLine = requestLine;
    }

    public HttpRequest(HttpRequestLine requestLine, List<HttpHeader> headers, HttpEntity entity) {
        super(headers, entity);
        this.requestLine = requestLine;
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        List<String> values = this.getParameters(name);
        if (values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public List<String> getParameters(String name) {
        List<String> values = new ArrayList<String>();
        if (name == null) {
            return values;
        }
        Map<String, List<String>> map = this.getParameterMap();
        values = map.get(name);
        if (values == null) {
            values = Collections.emptyList();
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> getParameterMap() {
        if (this.parameterMap != null) {
            return Collections.unmodifiableMap(this.parameterMap);
        }
        HttpRequest httpRequest = this;
        synchronized (httpRequest) {
            if (this.parameterMap != null) {
                return Collections.unmodifiableMap(this.parameterMap);
            }
            return Collections.unmodifiableMap(this.parseParameters());
        }
    }

    private Map<String, List<String>> parseParameters() {
        HttpContentType contentType;
        Map<String, List<String>> map = Collections.emptyMap();
        StringBuilder buf = new StringBuilder();
        String queryString = this.getQueryString();
        if (queryString != null) {
            buf.append(queryString);
        }
        if ((contentType = this.getContentType()) != null && MimeType.APPLICATION_X_WWW_FORM_URLENCODED == contentType.getMimeType()) {
            buf.append("&").append(this.getEntity().getContentAsString());
        }
        try {
            List<Map<String, List<String>>> paras = PARAMETER_DECODER.decode(buf.toString().getBytes(PARAMETER_DECODER.getCharset()));
            if (!paras.isEmpty()) {
                map = paras.get(0);
            }
        }
        catch (ProtocolException e) {
            LOG.warn("[CRAFT-ATOM-PROTOCOL-HTTP] Decode request parameter error", (Throwable)e);
            return map;
        }
        this.parameterMap = map;
        return this.parameterMap;
    }

    public String getQueryString() {
        if (this.requestLine == null) {
            return null;
        }
        String uri = this.requestLine.getUri();
        if (uri == null) {
            return null;
        }
        int idx = uri.indexOf("?");
        if (idx < 0) {
            return null;
        }
        return uri.substring(idx + 1);
    }

    @Override
    public void addCookie(HttpCookie cookie) {
        this.addHeader(HttpHeaders.newCookieHeader(cookie));
    }

    @Override
    protected List<HttpCookie> parseCookies() {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        List<HttpHeader> cookieHeaders = this.getHeaders(HttpHeaderType.COOKIE.getName());
        for (HttpHeader cookieHeader : cookieHeaders) {
            String cookieValue = cookieHeader.getValue();
            try {
                List<HttpCookie> cl = COOKIE_DECODER.decode(cookieValue.getBytes(COOKIE_DECODER.getCharset()));
                cookies.addAll(cl);
            }
            catch (ProtocolException e) {
                LOG.warn("[CRAFT-ATOM-PROTOCOL-HTTP] Decode request cookie error", (Throwable)e);
                return cookies;
            }
        }
        this.cookies = cookies;
        return this.cookies;
    }

    @Override
    public String toHttpString(Charset charset) {
        StringBuilder sb = new StringBuilder();
        HttpRequestLine requestLine = this.getRequestLine();
        if (requestLine != null) {
            sb.append(requestLine.toHttpString());
        }
        sb.append(super.toHttpString(charset));
        return sb.toString();
    }

    @Override
    public String toString() {
        return "HttpRequest(super=" + super.toString() + ", requestLine=" + this.getRequestLine() + ", parameterMap=" + this.getParameterMap() + ")";
    }

    public HttpRequestLine getRequestLine() {
        return this.requestLine;
    }

    public void setRequestLine(HttpRequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public void setParameterMap(Map<String, List<String>> parameterMap) {
        this.parameterMap = parameterMap;
    }
}

