/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

import io.craft.atom.protocol.ProtocolException;
import io.craft.atom.protocol.http.HttpCookieDecoder;
import io.craft.atom.protocol.http.HttpHeaders;
import io.craft.atom.protocol.http.api.HttpCodecFactory;
import io.craft.atom.protocol.http.model.HttpCookie;
import io.craft.atom.protocol.http.model.HttpEntity;
import io.craft.atom.protocol.http.model.HttpHeader;
import io.craft.atom.protocol.http.model.HttpHeaderType;
import io.craft.atom.protocol.http.model.HttpMessage;
import io.craft.atom.protocol.http.model.HttpStatusLine;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponse
extends HttpMessage {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResponse.class);
    private static final long serialVersionUID = 1532809882773093282L;
    private static final HttpCookieDecoder SET_COOKIE_DECODER = HttpCodecFactory.newHttpCookieDecoder(Charset.forName("utf-8"), true);
    private HttpStatusLine statusLine;

    public HttpResponse() {
    }

    public HttpResponse(HttpStatusLine statusLine, List<HttpHeader> headers) {
        super(headers);
        this.statusLine = statusLine;
    }

    public HttpResponse(HttpStatusLine statusLine, List<HttpHeader> headers, HttpEntity entity) {
        super(headers, entity);
        this.statusLine = statusLine;
    }

    @Override
    public void addCookie(HttpCookie cookie) {
        this.addHeader(HttpHeaders.newSetCookieHeader(cookie));
    }

    @Override
    protected List<HttpCookie> parseCookies() {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        List<HttpHeader> cookieHeaders = this.getHeaders(HttpHeaderType.COOKIE.getName());
        for (HttpHeader cookieHeader : cookieHeaders) {
            String cookieValue = cookieHeader.getValue();
            try {
                List<HttpCookie> cl = SET_COOKIE_DECODER.decode(cookieValue.getBytes(SET_COOKIE_DECODER.getCharset()));
                cookies.addAll(cl);
            }
            catch (ProtocolException e) {
                LOG.warn("[CRAFT-ATOM-PROTOCOL-HTTP] Decode response cookie error", (Throwable)e);
                return cookies;
            }
        }
        this.cookies = cookies;
        return this.cookies;
    }

    @Override
    public String toHttpString(Charset charset) {
        StringBuilder sb = new StringBuilder();
        HttpStatusLine statusLine = this.getStatusLine();
        if (statusLine != null) {
            sb.append(statusLine.toHttpString());
        }
        sb.append(super.toHttpString(charset));
        return sb.toString();
    }

    @Override
    public String toString() {
        return "HttpResponse(super=" + super.toString() + ", statusLine=" + this.getStatusLine() + ")";
    }

    public HttpStatusLine getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(HttpStatusLine statusLine) {
        this.statusLine = statusLine;
    }
}

