/*
 * Decompiled with CFR 0.152.
 */
package io.craft.atom.protocol.http.model;

public enum MimeType {
    APPLICATION_X_WWW_FORM_URLENCODED("application", "x-www-form-urlencoded"),
    APPLICATION_JSON("application", "json"),
    APPLICATION_XML("application", "xml"),
    APPLICATION_JAVASCRIPT("application", "javascript"),
    TEXT_HTML("text", "html"),
    TEXT_XML("text", "xml"),
    TEXT_PLAIN("text", "plain"),
    MULTIPART_FORM_DATA("multipart", "form-data"),
    WILDCARD("*", "*");

    private final String primaryType;
    private final String subType;

    public static MimeType from(String type) {
        if (APPLICATION_X_WWW_FORM_URLENCODED.toString().equalsIgnoreCase(type)) {
            return APPLICATION_X_WWW_FORM_URLENCODED;
        }
        if (APPLICATION_JSON.toString().equalsIgnoreCase(type)) {
            return APPLICATION_JSON;
        }
        if (APPLICATION_XML.toString().equalsIgnoreCase(type)) {
            return APPLICATION_XML;
        }
        if (APPLICATION_JAVASCRIPT.toString().equalsIgnoreCase(type)) {
            return APPLICATION_JAVASCRIPT;
        }
        if (TEXT_HTML.toString().equalsIgnoreCase(type)) {
            return TEXT_HTML;
        }
        if (TEXT_XML.toString().equalsIgnoreCase(type)) {
            return TEXT_XML;
        }
        if (TEXT_PLAIN.toString().equalsIgnoreCase(type)) {
            return TEXT_PLAIN;
        }
        if (MULTIPART_FORM_DATA.toString().equalsIgnoreCase(type)) {
            return MULTIPART_FORM_DATA;
        }
        if (MULTIPART_FORM_DATA.toString().equalsIgnoreCase(type)) {
            return MULTIPART_FORM_DATA;
        }
        throw new IllegalArgumentException("unsupported content type.");
    }

    public String toString() {
        return this.primaryType + "/" + this.subType;
    }

    private MimeType(String primaryType, String subType) {
        this.primaryType = primaryType;
        this.subType = subType;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }
}

