/*
 * Decompiled with CFR 0.152.
 */
package scalapb.ujson;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scalapb.descriptors.Descriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PBoolean$;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PDouble$;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PFloat$;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PInt$;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PLong$;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PMessage$;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PRepeated$;
import scalapb.descriptors.PString;
import scalapb.descriptors.PString$;
import scalapb.descriptors.PValue;
import scalapb.descriptors.ScalaType;
import scalapb.ujson.FieldVisitor;
import scalapb.ujson.FieldVisitor$;
import scalapb.ujson.JsonReadException;
import scalapb.ujson.JsonReadException$;
import scalapb.ujson.KeyVisitor$;
import upickle.core.ObjVisitor;
import upickle.core.Visitor;

public class MapReader
implements ObjVisitor<PValue, PValue> {
    private final FieldDescriptor fd;
    private final Descriptor mapEntryDescriptor;
    private final FieldDescriptor keyDescriptor;
    private final FieldDescriptor valueDescriptor;
    private int keyIndex;
    private PValue key;
    private final FieldVisitor fv;
    private final ArrayBuffer<Map> entries;

    public MapReader(int sizeHint, FieldDescriptor fd) {
        this.fd = fd;
        this.mapEntryDescriptor = ((ScalaType.Message)fd.scalaType()).descriptor();
        this.keyDescriptor = (FieldDescriptor)this.mapEntryDescriptor().findFieldByNumber(1).get();
        this.valueDescriptor = (FieldDescriptor)this.mapEntryDescriptor().findFieldByNumber(2).get();
        this.keyIndex = -1;
        this.key = null;
        this.fv = new FieldVisitor(this.valueDescriptor(), FieldVisitor$.MODULE$.$lessinit$greater$default$2());
        this.entries = ArrayBuffer$.MODULE$.empty();
        this.entries.sizeHint(sizeHint);
    }

    public Descriptor mapEntryDescriptor() {
        return this.mapEntryDescriptor;
    }

    public FieldDescriptor keyDescriptor() {
        return this.keyDescriptor;
    }

    public FieldDescriptor valueDescriptor() {
        return this.valueDescriptor;
    }

    public FieldVisitor fv() {
        return this.fv;
    }

    public Visitor<?, ?> visitKey(int index) {
        this.keyIndex = index;
        return KeyVisitor$.MODULE$;
    }

    public void visitKeyValue(Object v) {
        Option keyValueOpt;
        Option option;
        String keyString = (String)v;
        ScalaType scalaType = this.keyDescriptor().scalaType();
        if (ScalaType.Boolean$.MODULE$.equals(scalaType)) {
            option = StringOps$.MODULE$.toBooleanOption$extension(Predef$.MODULE$.augmentString(keyString)).map((Function1 & Serializable)v1 -> new PBoolean(PBoolean$.MODULE$.apply(BoxesRunTime.unboxToBoolean((Object)v1))));
        } else if (ScalaType.Double$.MODULE$.equals(scalaType)) {
            option = StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(keyString)).map((Function1 & Serializable)v1 -> new PDouble(PDouble$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)v1))));
        } else if (ScalaType.Float$.MODULE$.equals(scalaType)) {
            option = StringOps$.MODULE$.toFloatOption$extension(Predef$.MODULE$.augmentString(keyString)).map((Function1 & Serializable)v1 -> new PFloat(PFloat$.MODULE$.apply(BoxesRunTime.unboxToFloat((Object)v1))));
        } else if (ScalaType.Int$.MODULE$.equals(scalaType)) {
            option = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(keyString)).map((Function1 & Serializable)v1 -> new PInt(PInt$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)v1))));
        } else if (ScalaType.Long$.MODULE$.equals(scalaType)) {
            option = StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(keyString)).map((Function1 & Serializable)v1 -> new PLong(PLong$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)v1))));
        } else if (ScalaType.String$.MODULE$.equals(scalaType)) {
            option = Some$.MODULE$.apply((Object)new PString(PString$.MODULE$.apply(keyString)));
        } else {
            throw new JsonReadException("illegal key type", this.keyIndex, JsonReadException$.MODULE$.$lessinit$greater$default$3());
        }
        Option option2 = keyValueOpt = option;
        if (None$.MODULE$.equals(option2)) {
            throw new JsonReadException(new StringBuilder(41).append("cannot parse key '").append(keyString).append("' of map field '").append(this.fd.fullName()).append("' as a ").append(this.keyDescriptor().scalaType()).toString(), this.keyIndex, JsonReadException$.MODULE$.$lessinit$greater$default$3());
        }
        if (option2 instanceof Some) {
            Object pvalue = ((Some)option2).value();
            this.key = (PValue)pvalue;
            return;
        }
        throw new MatchError((Object)option2);
    }

    public Visitor<?, ?> subVisitor() {
        return this.fv();
    }

    public void visitValue(PValue v, int index) {
        Object[] objectArray = new Tuple2[2];
        FieldDescriptor fieldDescriptor = (FieldDescriptor)Predef$.MODULE$.ArrowAssoc((Object)this.keyDescriptor());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)fieldDescriptor, (Object)this.key);
        FieldDescriptor fieldDescriptor2 = (FieldDescriptor)Predef$.MODULE$.ArrowAssoc((Object)this.valueDescriptor());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)fieldDescriptor2, (Object)v);
        Map entry = PMessage$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        this.entries.$plus$eq((Object)new PMessage(entry));
    }

    public PValue visitEnd(int index) {
        return new PRepeated(PRepeated$.MODULE$.apply(this.entries.toVector()));
    }
}

