/*
 * Decompiled with CFR 0.152.
 */
package scalapb.ujson;

import com.google.protobuf.duration.Duration;
import com.google.protobuf.duration.Duration$;
import com.google.protobuf.timestamp.Timestamp;
import com.google.protobuf.timestamp.Timestamp$;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import scala.Int$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

public final class TimeUtils$
implements Serializable {
    public static final TimeUtils$ MODULE$ = new TimeUtils$();

    private TimeUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeUtils$.class);
    }

    public String writeTimestamp(Timestamp ts) {
        return this.writeTimestamp(ts.seconds(), ts.nanos());
    }

    public String writeTimestamp(long seconds, int nanos) {
        return Instant.ofEpochSecond(seconds, Int$.MODULE$.int2long(nanos)).toString();
    }

    public Timestamp parseTimestamp(String value) {
        Instant instant = Instant.parse(value);
        return Timestamp$.MODULE$.apply(instant.getEpochSecond(), instant.getNano(), Timestamp$.MODULE$.$lessinit$greater$default$3());
    }

    public String formatNanos(int nanos) {
        if (nanos % 1000000 == 0) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%1$03d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / 1000000))}));
        }
        if (nanos % 1000 == 0) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%1$06d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(nanos / 1000))}));
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%1$09d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nanos)}));
    }

    public String writeDuration(Duration d) {
        return this.writeDuration(d.seconds(), d.nanos());
    }

    public String writeDuration(long seconds, int nanos) {
        StringBuilder r = new StringBuilder();
        if (seconds < 0L || nanos < 0) {
            r.append("-");
        }
        r.append(RichLong$.MODULE$.abs$extension(Predef$.MODULE$.longWrapper(seconds)));
        if (nanos != 0) {
            r.append(".");
            r.append(this.formatNanos(nanos));
        }
        r.append("s");
        return r.result();
    }

    public Duration parseDuration(String value) {
        int nanos;
        if (!value.endsWith("s")) {
            throw new ParseException(new java.lang.StringBuilder(25).append("Invalid duration string: ").append(value).toString(), 0);
        }
        Tuple2 tuple2 = value.startsWith("-") ? Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)value.substring(1, value.length() - 1)) : Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)value.substring(0, value.length() - 1));
        boolean negative = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        String number = (String)tuple2._2();
        int pointPosition = number.indexOf(46);
        Tuple2 tuple22 = pointPosition != -1 ? Tuple2$.MODULE$.apply((Object)number.substring(0, pointPosition), (Object)number.substring(pointPosition + 1)) : Tuple2$.MODULE$.apply((Object)number, (Object)"");
        String secondsStr = (String)tuple22._1();
        String nanosStr = (String)tuple22._2();
        long seconds = StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(secondsStr));
        int n = nanos = nanosStr.isEmpty() ? 0 : StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(nanosStr));
        if (seconds < 0L) {
            throw new ParseException(new java.lang.StringBuilder(25).append("Invalid duration string: ").append(value).toString(), 0);
        }
        return Duration$.MODULE$.apply(negative ? -seconds : seconds, negative ? -nanos : nanos, Duration$.MODULE$.$lessinit$greater$default$3());
    }
}

