/*
 * Decompiled with CFR 0.152.
 */
package paymentslip;

import br.com.caelum.stella.boleto.Banco;
import br.com.caelum.stella.boleto.Beneficiario;
import br.com.caelum.stella.boleto.Boleto;
import br.com.caelum.stella.boleto.Datas;
import br.com.caelum.stella.boleto.Endereco;
import br.com.caelum.stella.boleto.Pagador;
import br.com.caelum.stella.boleto.transformer.GeradorDeBoleto;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import paymentslip.Bank;

@CronapiMetaData(categoryName="{{Category.PaymentSlip}}")
public class PaymentSlip {
    @CronapiMetaData(type="function", name="{{createDateOfPaymentSlip}}", description="{{createDateOfPaymentSlipDescription}}", returnType=CronapiMetaData.ObjectType.MAP)
    public static Var createDatesOfPaymentSlip(@ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{day}}") Var day, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{month}}") Var month, @ParamMetaData(type=CronapiMetaData.ObjectType.LONG, description="{{year}}") Var year) throws Exception {
        LinkedHashMap<String, Integer> mapDate = new LinkedHashMap<String, Integer>();
        mapDate.put("day", day.getObjectAsLong().intValue());
        mapDate.put("month", month.getObjectAsLong().intValue());
        mapDate.put("year", year.getObjectAsLong().intValue());
        return Var.valueOf(mapDate);
    }

    @CronapiMetaData(type="function", name="{{defineDatesOfPaymentSlip}}", description="{{defineDatesOfPaymentSlipDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var defineDatesOfPaymentSlip(@ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{documentDate}}") Var documentDate, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{processingDate}}") Var processingDate, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{dueDate}}") Var dueDate) throws Exception {
        String day = "day";
        String month = "month";
        String year = "year";
        Map mapDocumentDate = documentDate.getObjectAsMap();
        Map mapProcessingDate = processingDate.getObjectAsMap();
        Map mapDueDate = dueDate.getObjectAsMap();
        Datas datas = Datas.novasDatas().comDocumento(((Integer)mapDocumentDate.get(day)).intValue(), ((Integer)mapDocumentDate.get(month)).intValue(), ((Integer)mapDocumentDate.get(year)).intValue()).comProcessamento(((Integer)mapProcessingDate.get(day)).intValue(), ((Integer)mapProcessingDate.get(month)).intValue(), ((Integer)mapProcessingDate.get(year)).intValue()).comVencimento(((Integer)mapDueDate.get(day)).intValue(), ((Integer)mapDueDate.get(month)).intValue(), ((Integer)mapDueDate.get(year)).intValue());
        return Var.valueOf((Object)datas);
    }

    @CronapiMetaData(type="function", name="{{createAddress}}", description="{{createAddressDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var createAddress(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{publicPlace}}") Var publicPlace, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{neighborhood}}") Var neighborhood, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{cep}}") Var cep, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{city}}") Var city, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{uf}}") Var uf) {
        Endereco endereco = Endereco.novoEndereco().comLogradouro(publicPlace.getObjectAsString()).comBairro(neighborhood.getObjectAsString()).comCep(cep.getObjectAsString()).comCidade(city.getObjectAsString()).comUf(uf.getObjectAsString());
        return Var.valueOf((Object)endereco);
    }

    @CronapiMetaData(type="function", name="{{createFavored}}", description="{{createFavoredDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var createFavored(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{favored}}") Var favored, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{agency}}") Var agency, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{agencyDigit}}") Var agencyDigit, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{codFavored}}") Var codFavored, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{digitCodFavored}}") Var digitCodFavored, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{numberAgreement}}") Var numberAgreement, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{wallet}}") Var wallet, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{address}}") Var address, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{number}}") Var number) {
        Beneficiario favoredInstance = Beneficiario.novoBeneficiario().comNomeBeneficiario(favored.getObjectAsString()).comAgencia(agency.getObjectAsString()).comDigitoAgencia(agencyDigit.getObjectAsString()).comCodigoBeneficiario(codFavored.getObjectAsString()).comDigitoCodigoBeneficiario(digitCodFavored.getObjectAsString()).comNumeroConvenio(numberAgreement.getObjectAsString()).comCarteira(wallet.getObjectAsString()).comEndereco((Endereco)address.getTypedObject(Endereco.class)).comNossoNumero(number.getObjectAsString());
        return Var.valueOf((Object)favoredInstance);
    }

    @CronapiMetaData(type="function", name="{{createPayer}}", description="{{createPayerDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var createPayer(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{name}}") Var name, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{document}}") Var document, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{address}}") Var address) {
        Pagador payer = Pagador.novoPagador().comNome(name.getObjectAsString()).comDocumento(document.getObjectAsString()).comEndereco((Endereco)address.getTypedObject(Endereco.class));
        return Var.valueOf((Object)payer);
    }

    @CronapiMetaData(type="function", name="{{chooseBank}}", description="{{chooseBankDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var chooseBank(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{bank}}", blockType="util_dropdown", values={"Banco do Brasil", "Bradesco", "Caixa", "HSBC", "Ita\u00fa", "Santander"}, keys={"BANCO_DO_BRASIL", "BRADESCO", "CAIXA", "HSBC", "ITAU", "SANTANDER"}) Var bank) {
        return Var.valueOf((Object)Bank.valueOf(bank.getObjectAsString()).getInstance());
    }

    @CronapiMetaData(type="function", name="{{createInstanceOfPaymentSlip}}", description="{{createInstanceOfPaymentSlipDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static Var createInstanceOfPaymentSlip(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{bank}}") Var bank, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{dates}}") Var dates, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{favored}}") Var favored, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{payer}}") Var payer, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{value}}") Var value, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{documentNumber}}") Var documentNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.LIST, description="{{instructions}}") Var instructions, @ParamMetaData(type=CronapiMetaData.ObjectType.LIST, description="{{paymentlocations}}") Var paymentlocations) {
        Boleto boleto = Boleto.novoBoleto().comBanco((Banco)bank.getTypedObject(Banco.class)).comDatas((Datas)dates.getTypedObject(Datas.class)).comBeneficiario((Beneficiario)favored.getTypedObject(Beneficiario.class)).comPagador((Pagador)payer.getTypedObject(Pagador.class)).comValorBoleto(value.getObjectAsString()).comNumeroDoDocumento(value.getObjectAsString()).comInstrucoes(PaymentSlip.createInstructionsOrLocationsList(instructions).toArray(new String[0])).comLocaisDePagamento(PaymentSlip.createInstructionsOrLocationsList(paymentlocations).toArray(new String[0]));
        return Var.valueOf((Object)boleto);
    }

    private static List<String> createInstructionsOrLocationsList(Var str) {
        List<String> list = new ArrayList<String>();
        if (!str.isEmptyOrNull().booleanValue() && str.getObject() instanceof String) {
            list.add(str.getObjectAsString());
        } else if (!str.isEmptyOrNull().booleanValue()) {
            list = (List)str.getTypedObject(List.class);
        }
        return list;
    }

    @CronapiMetaData(type="function", name="{{generatePaymentSlip}}", description="{{generatePaymentSlipDescription}}", returnType=CronapiMetaData.ObjectType.OBJECT)
    public static void generatePaymentSlip(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{paymentSlipInstance}}") Var paymentSlips, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{path}}") Var path, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{archiveName}}") Var archiveName, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{archiveFormat}}", blockType="util_dropdown", keys={"PNG", "PDF"}) Var archiveFormat) {
        StringBuilder fullPath = new StringBuilder().append(path.getObjectAsString()).append(archiveName.getObjectAsString()).append(".").append(archiveFormat.getObjectAsString().toLowerCase());
        GeradorDeBoleto paymentSlipGenerate = PaymentSlip.createGeneratorPayments(paymentSlips);
        if (archiveFormat.getObjectAsString().equals("PNG")) {
            paymentSlipGenerate.geraPNG(fullPath.toString());
        } else {
            paymentSlipGenerate.geraPDF(fullPath.toString());
        }
    }

    @CronapiMetaData(type="function", name="{{generatePaymentSlipByteArray}}", description="{{generatePaymentSlipByteArrayDescription}}", returnType=CronapiMetaData.ObjectType.UNKNOWN)
    public static Var generatePaymentSlipByteArray(@ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{paymentSlips}}") Var paymentSlips, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{archiveFormat}}", blockType="util_dropdown", keys={"PNG", "PDF"}) Var archiveFormat) {
        GeradorDeBoleto paymentSlipGenerate = PaymentSlip.createGeneratorPayments(paymentSlips);
        if (archiveFormat.getObjectAsString().equals("PNG")) {
            return Var.valueOf((Object)paymentSlipGenerate.geraPNG());
        }
        return Var.valueOf((Object)paymentSlipGenerate.geraPDF());
    }

    private static GeradorDeBoleto createGeneratorPayments(Var paymentSlips) {
        List paymentSlipList = new ArrayList<Boleto>();
        if (paymentSlips.getObject() instanceof List) {
            paymentSlipList = (List)paymentSlips.getTypedObject(List.class);
        } else {
            paymentSlipList.add((Boleto)paymentSlips.getTypedObject(Boleto.class));
        }
        return new GeradorDeBoleto(paymentSlipList.toArray(new Boleto[0]));
    }
}

