/*
 * Decompiled with CFR 0.152.
 */
package cronapi.excel;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

@CronapiMetaData(categoryName="Excel")
public class Excel {
    @CronapiMetaData(name="{{createSpreadSheet}}", description="{{createSpreadSheetDescription}}", nameTags={"Criar Excel", "Criar Arquivo Excel", "Create Excel", "Create File Excel"}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var createSpreadSheet() {
        XSSFWorkbook workbook = new XSSFWorkbook();
        return Var.valueOf((Object)workbook);
    }

    @CronapiMetaData(name="{{createSheet}}", description="{{createSheetDescription}}", nameTags={"Criar Aba", "Aba", "Create Sheet", "Sheet"}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var createSheet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{workbook}}") Var workbook, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{nameDescription}}") Var name) {
        XSSFSheet sheet = ((XSSFWorkbook)workbook.getTypedObject(XSSFWorkbook.class)).createSheet(name.getObjectAsString());
        return Var.valueOf((Object)sheet);
    }

    @CronapiMetaData(name="{{createLine}}", description="{{createLineDescription}}", nameTags={"Criar Linha", "Linha", "Create Line", "Line"}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var createLine(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet) {
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        return Var.valueOf((Object)row);
    }

    @CronapiMetaData(name="{{getCellValue}}", description="{{getCellValueDescription}}", nameTags={"Obter Valor", "Valor Celula", "Get Value", "Value Cell"}, returnType=CronapiMetaData.ObjectType.OBJECT)
    public static final Var getCellValue(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet) {
        Var valor;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        XSSFCell cell = row.getCell(columnNumber.getObjectAsInt().intValue());
        switch (cell.getCellType()) {
            case BLANK: {
                valor = Var.valueOf((Object)cell.getRawValue());
                break;
            }
            case BOOLEAN: {
                valor = Var.valueOf((Object)cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                valor = Var.valueOf((Object)cell.getErrorCellString());
                break;
            }
            case FORMULA: {
                valor = Var.valueOf((Object)cell.getCellFormula());
                break;
            }
            case NUMERIC: {
                valor = Var.valueOf((Object)cell.getNumericCellValue());
                break;
            }
            default: {
                valor = Var.valueOf((Object)cell.getStringCellValue());
            }
        }
        return valor;
    }

    @CronapiMetaData(name="{{insertCellContent}}", description="{{insertCellContentDescription}}", nameTags={"Inserir Conte\u00fado", "Conteudo Celula", "Insert Content", "Content Cell"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void insertCellValue(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentSheet}}") Var value) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        switch (value.getType()) {
            case STRING: {
                cell.setCellValue(value.getObjectAsString());
                break;
            }
            case INT: {
                cell.setCellValue((double)value.getObjectAsInt().intValue());
                break;
            }
            case DOUBLE: {
                cell.setCellValue(value.getObjectAsDouble().doubleValue());
                break;
            }
            case BOOLEAN: {
                cell.setCellValue(value.getObjectAsBoolean().booleanValue());
                break;
            }
            case DATETIME: {
                cell.setCellValue(value.getObjectAsDateTime());
                break;
            }
            default: {
                cell.setCellValue(value.getObjectAsString());
            }
        }
    }

    @CronapiMetaData(name="{{setCellType}}", description="{{setCellTypeDescription}}", nameTags={"Tipo C\u00e9lula", "Formato Conte\u00fado", "Set Cell Type", "Cell Type"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setCellType(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{cellType}}", blockType="util_dropdown", values={"{{cellTypeNumeric}}", "{{cellTypeText}}", "{{cellTypeFormula}}", "{{cellTypeWhite}}", "{{cellTypeBoolean}}", "{{cellTypeError}}"}, keys={"0", "1", "2", "3", "4", "5"}) Var cellType) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        cell.setCellType(CellType.forInt((int)cellType.getObjectAsInt()));
    }

    @CronapiMetaData(name="{{alignCellTextHorizontal}}", description="{{alignCellTextHorizontalDescription}}", nameTags={"Alinhamento Horizontal", "Alinhamento", "Align Horizontal", "Align"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void alignCellTextHorizontal(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{alignType}}", blockType="util_dropdown", values={"{{alignTypeLeft}}", "{{alignTypeCenter}}", "{{alignTypeRight}}"}, keys={"1", "2", "3"}) Var alignType) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        CellStyle style = cell.getCellStyle();
        style.setAlignment(HorizontalAlignment.forInt((int)alignType.getObjectAsInt()));
        cell.setCellStyle(style);
    }

    @CronapiMetaData(name="{{alignCellTextVertical}}", description="{{alignCellTextVerticalDescription}}", nameTags={"Alinhamento Vertical", "Alinhamento", "Align Vertical", "Align"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void alignCellTextVertical(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{alignType}}", blockType="util_dropdown", values={"{{alignTypeVerticalTop}}", "{{alignTypeVerticalCenter}}", "{{alignTypeVerticalBottom}}", "{{alignTypeVerticalJustify}}"}, keys={"0", "1", "2", "3"}) Var alignType) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        CellStyle style = cell.getCellStyle();
        style.setVerticalAlignment(VerticalAlignment.forInt((int)alignType.getObjectAsInt()));
        cell.setCellStyle(style);
    }

    @CronapiMetaData(name="{{setFontProperties}}", description="{{setFontPropertiesDescription}}", nameTags={"Definir Fonte", "Propriedades da Fonte", "Set Font", "Font Properties"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setFontProperties(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fontType}}", blockType="util_dropdown", values={"{{fontTypeItalic}}", "{{fontTypeBold}}", "{{fontTypeUnderline}}", "{{fontTypeStrikeout}}"}, keys={"0", "1", "2", "3"}) Var fontType, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fontColor}}", blockType="util_dropdown", values={"{{fontColorYellow}}", "{{fontColorWhite}}", "{{fontColorRed}}", "{{fontColorPink}}", "{{fontColorGreen}}", "{{fontColorOrange}}", "{{fontColorMagenta}}", "{{fontColorGray1}}", "{{fontColorGray}}", "{{fontColorGray2}}", "{{fontColorBlue1}}", "{{fontColorBlue}}", "{{fontColorBlack}}"}, keys={"13", "9", "10", "14", "17", "53", "6", "22", "23", "63", "49", "12", "8", "14"}) Var fontColor) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        XSSFWorkbook workbook = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getWorkbook();
        XSSFCellStyle style = workbook.createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        XSSFFont font = workbook.createFont();
        switch (fontType.getObjectAsString()) {
            case "0": {
                font.setItalic(true);
                break;
            }
            case "1": {
                font.setBold(true);
                break;
            }
            case "2": {
                font.setUnderline((byte)1);
                break;
            }
            case "3": {
                font.setStrikeout(true);
            }
        }
        font.setColor(IndexedColors.fromInt((int)fontColor.getObjectAsInt()).getIndex());
        style.setFont((Font)font);
        cell.setCellStyle((CellStyle)style);
    }

    @CronapiMetaData(name="{{setBorder}}", description="{{setBorderDescription}}", nameTags={"Tipo de Borda", "Borda", "Set Border", "Border Type"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setBorder(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{borderType}}", blockType="util_dropdown", values={"{{borderTypeDotted}}", "{{borderTypeDashed}}", "{{borderTypeThick}}", "{{borderTypeThin}}"}, keys={"0", "1", "2", "3"}) Var borderType) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        XSSFCellStyle style = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        switch (borderType.getObjectAsString()) {
            case "0": {
                style.setBorderRight(BorderStyle.DOTTED);
                style.setBorderLeft(BorderStyle.DOTTED);
                style.setBorderTop(BorderStyle.DOTTED);
                style.setBorderBottom(BorderStyle.DOTTED);
                break;
            }
            case "1": {
                style.setBorderRight(BorderStyle.DASHED);
                style.setBorderLeft(BorderStyle.DASHED);
                style.setBorderTop(BorderStyle.DASHED);
                style.setBorderBottom(BorderStyle.DASHED);
                break;
            }
            case "2": {
                style.setBorderRight(BorderStyle.THICK);
                style.setBorderLeft(BorderStyle.THICK);
                style.setBorderTop(BorderStyle.THICK);
                style.setBorderBottom(BorderStyle.THICK);
                break;
            }
            case "3": {
                style.setBorderRight(BorderStyle.THIN);
                style.setBorderLeft(BorderStyle.THIN);
                style.setBorderTop(BorderStyle.THIN);
                style.setBorderBottom(BorderStyle.THIN);
            }
        }
        cell.setCellStyle((CellStyle)style);
    }

    @CronapiMetaData(name="{{setBorderColor}}", description="{{setBorderColorDescription}}", nameTags={"Cor da Borda", "Borda", "Border Color", "Border"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setBorderColor(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{colorType}}", blockType="util_dropdown", values={"{{fontColorYellow}}", "{{fontColorWhite}}", "{{fontColorRed}}", "{{fontColorPink}}", "{{fontColorGreen}}", "{{fontColorOrange}}", "{{fontColorMagenta}}", "{{fontColorGray1}}", "{{fontColorGray}}", "{{fontColorGray2}}", "{{fontColorBlue1}}", "{{fontColorBlue}}", "{{fontColorBlack}}"}, keys={"13", "9", "10", "14", "17", "53", "6", "22", "23", "63", "49", "12", "8", "14", "17"}) Var colorType) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        XSSFCellStyle style = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        style.setTopBorderColor(IndexedColors.fromInt((int)colorType.getObjectAsInt()).getIndex());
        style.setRightBorderColor(IndexedColors.fromInt((int)colorType.getObjectAsInt()).getIndex());
        style.setLeftBorderColor(IndexedColors.fromInt((int)colorType.getObjectAsInt()).getIndex());
        style.setBottomBorderColor(IndexedColors.fromInt((int)colorType.getObjectAsInt()).getIndex());
        cell.setCellStyle((CellStyle)style);
    }

    @CronapiMetaData(name="{{setBackgroundColor}}", description="{{setBackgroundColorDescription}}", nameTags={"Cor de Preenchimento", "Preenchimento", "Background Color", "Color"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void setBackgroundColor(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{colorType}}", blockType="util_dropdown", values={"{{fontColorYellow}}", "{{fontColorWhite}}", "{{fontColorRed}}", "{{fontColorPink}}", "{{fontColorGreen}}", "{{fontColorOrange}}", "{{fontColorMagenta}}", "{{fontColorGray1}}", "{{fontColorGray}}", "{{fontColorGray2}}", "{{fontColorBlue1}}", "{{fontColorBlue}}", "{{fontColorBlack}}"}, keys={"13", "9", "10", "14", "17", "53", "6", "22", "23", "63", "49", "12", "8", "14", "17"}) Var cellColor, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fillPattern}}", blockType="util_dropdown", values={"{{fillPatternNone}}", "{{fillPatternSolidForeground}}", "{{fillPatternFineDots}}", "{{fillPatternAltBars}}", "{{fillPatternSparseDots}}", "{{fillPatternThickHorzBands}}", "{{fillPatternThickVertBands}}"}, keys={"0", "1", "2", "3", "4", "5", "6"}) Var fillPattern) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        XSSFCellStyle style = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getWorkbook().createCellStyle();
        style.cloneStyleFrom(cell.getCellStyle());
        style.setFillBackgroundColor(IndexedColors.fromInt((int)cellColor.getObjectAsInt()).getIndex());
        style.setFillPattern(FillPatternType.forInt((int)fillPattern.getObjectAsInt()));
        cell.setCellStyle((CellStyle)style);
    }

    @CronapiMetaData(name="{{createLineWithContentSet}}", description="{{createLineWithContentSetDescription}}", nameTags={"Criar Linha", "Linha", "Create Line", "Line"}, returnType=CronapiMetaData.ObjectType.UNKNOWN)
    public static final void createLineWithValueSet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.OBJECT, description="{{contentSheet}}") Var name) {
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        block7: for (int i = 0; i < name.getObjectAsList().size(); ++i) {
            Cell cell = row.createCell(i);
            Var listObject = Var.valueOf(name.getObjectAsList().get(i));
            switch (listObject.getType()) {
                case STRING: {
                    cell.setCellValue(listObject.getObjectAsString());
                    continue block7;
                }
                case INT: {
                    cell.setCellValue((double)listObject.getObjectAsInt().intValue());
                    continue block7;
                }
                case DOUBLE: {
                    cell.setCellValue(listObject.getObjectAsDouble().doubleValue());
                    continue block7;
                }
                case BOOLEAN: {
                    cell.setCellValue(listObject.getObjectAsBoolean().booleanValue());
                    continue block7;
                }
                case DATETIME: {
                    cell.setCellValue(listObject.getObjectAsDateTime());
                    continue block7;
                }
                default: {
                    cell.setCellValue(listObject.getObjectAsString());
                }
            }
        }
    }

    @CronapiMetaData(name="{{createHyperlink}}", description="{{createHyperlinkDescription}}", nameTags={"Criar Hyperlink", "Hyperlink", "Create Hyperlink"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void createHyperlink(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{rowNumber}}") Var rowNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var columnNumber, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fileExcel}}") Var excel, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{address}}") Var address, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{textHyperlink}}") Var text, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{hyperlinkType}}", blockType="util_dropdown", values={"{{hyperlinkTypeDocument}}", "{{hyperlinkTypeEmail}}", "{{hyperlinkTypeFile}}", "{{hyperlinkTypeURL}}", "{{hyperlinkTypeNone}}"}, keys={"DOCUMENT", "EMAIL", "FILE", "URL", "NONE"}) Var hyperlinkType) {
        Cell cell;
        XSSFRow row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).getRow(rowNumber.getObjectAsInt().intValue());
        if (row == null) {
            row = ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).createRow(rowNumber.getObjectAsInt().intValue());
        }
        if ((cell = row.getCell(columnNumber.getObjectAsInt().intValue())) == null) {
            cell = row.createCell(columnNumber.getObjectAsInt().intValue());
        }
        Workbook workbook = (Workbook)excel.getTypedObject(Workbook.class);
        CellStyle style = cell.getCellStyle();
        Font fontStyle = workbook.createFont();
        fontStyle.setUnderline((byte)1);
        fontStyle.setColor(IndexedColors.BLUE.getIndex());
        style.setFont(fontStyle);
        cell.setCellValue(text.getObjectAsString());
        Hyperlink link = workbook.getCreationHelper().createHyperlink(HyperlinkType.valueOf((String)hyperlinkType.getObjectAsString()));
        link.setAddress(address.getObjectAsString());
        cell.setHyperlink(link);
    }

    @CronapiMetaData(name="{{mergeCells}}", description="{{mergeCellsDescription}}", nameTags={"Mesclar", "C\u00e9lula", "Merge Cells"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void mergeCells(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firstRow}}") Var firstRow, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{lastRow}}") Var lastRow, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{firstCol}}") Var firstCol, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{lastCol}}") Var lastCol) {
        CellRangeAddress range = new CellRangeAddress(firstRow.getObjectAsInt().intValue(), lastRow.getObjectAsInt().intValue(), firstCol.getObjectAsInt().intValue(), lastCol.getObjectAsInt().intValue());
        ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).addMergedRegion(range);
    }

    @CronapiMetaData(name="{{autoSizeColumn}}", description="{{autoSizeColumnDescription}}", nameTags={"Ajustar", "Coluna", "Auto Size"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void autoSize(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sheet}}") Var sheet, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{columnNumber}}") Var column) {
        ((XSSFSheet)sheet.getTypedObject(XSSFSheet.class)).autoSizeColumn(column.getObjectAsInt().intValue());
    }

    @CronapiMetaData(name="{{saveSpreadSheet}}", description="{{saveSpreadSheetDescription}}", nameTags={"Salvar", "Planilha", "Save", "Spread Sheet"}, returnType=CronapiMetaData.ObjectType.VOID)
    public static final void saveSpreadSheet(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{fileExcel}}") Var workbook, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{nameDescription}}") Var name, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{pathLocation}}") Var path) throws Exception {
        StringBuilder sbPath = new StringBuilder();
        sbPath.append(path.getObjectAsString());
        sbPath.append(File.separator);
        sbPath.append(name.getObjectAsString());
        sbPath.append(".xlsx");
        File arquivo = new File(sbPath.toString());
        FileOutputStream out = new FileOutputStream(arquivo);
        ((XSSFWorkbook)workbook.getTypedObject(XSSFWorkbook.class)).write((OutputStream)out);
        out.close();
    }
}

