/*
 * Decompiled with CFR 0.152.
 */
package cronapi.posts;

import com.restfb.BinaryAttachment;
import com.restfb.Connection;
import com.restfb.DefaultFacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.types.Comment;
import com.restfb.types.Conversation;
import com.restfb.types.GraphResponse;
import com.restfb.types.Post;
import com.restfb.types.User;
import com.restfb.types.send.IdMessageRecipient;
import com.restfb.types.send.Message;
import com.restfb.types.send.SendResponse;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

@CronapiMetaData(categoryName="Facebook")
public final class FacebookPosts {
    @CronapiMetaData(type="function", name="{{publishPostPage}}", nameTags={"Novo Post, Publicar", "New Tag", "Publish"}, description="{{publishPostPageDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var publishPostPage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentPost}}") Var message) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        GraphResponse publishMessageResponse = (GraphResponse)pageClient.publish("me/feed", GraphResponse.class, new Parameter[]{Parameter.with((String)"message", (Object)message.getObjectAsString())});
        return new Var((Object)publishMessageResponse.getId());
    }

    @CronapiMetaData(type="function", name="{{publishPostPageWithLink}}", nameTags={"Novo Post Link, Publicar Link", "New Post Link", "Publish Link"}, description="{{publishPostPageWithLinkDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var publishPostWithLinkPage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentPost}}") Var message, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{linkForPublishPost}}") Var link) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        GraphResponse publishMessageResponse = (GraphResponse)pageClient.publish("me/feed", GraphResponse.class, new Parameter[]{Parameter.with((String)"link", (Object)link.getObjectAsString()), Parameter.with((String)"message", (Object)message.getObjectAsString())});
        return new Var((Object)publishMessageResponse.getId());
    }

    @CronapiMetaData(type="function", name="{{schedulePublishPostPage}}", nameTags={"Agendar Novo Post, Publicar", "Schedule new Post", "Publish"}, description="{{schedulePublishPostPageDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var schedulePublishPostPage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentPost}}") Var message, @ParamMetaData(type=CronapiMetaData.ObjectType.DATETIME, description="{{dateSchedule}}") Var date) throws Exception {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        TimeZone tz = date.getObjectAsDateTime().getTimeZone();
        ZoneId zoneId = tz.toZoneId();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(date.getObjectAsDateTime().toInstant(), zoneId);
        long minutes = ChronoUnit.MINUTES.between(LocalDateTime.now(), localDateTime);
        if (date.isEmptyOrNull().booleanValue() || minutes < 10L) {
            throw new Exception("O Agendamento de uma Publica\u00e7\u00e3o precisa ter uma diferen\u00e7a entre 10 minutos e 6 Meses da Data/Hora Atual");
        }
        GraphResponse publishMessageResponse = (GraphResponse)pageClient.publish("me/feed", GraphResponse.class, new Parameter[]{Parameter.with((String)"message", (Object)message.getObjectAsString()), Parameter.with((String)"published", (Object)Boolean.FALSE), Parameter.with((String)"scheduled_publish_time", (Object)(date.getObjectAsDateTime().getTime().getTime() / 1000L))});
        return new Var((Object)publishMessageResponse.getId());
    }

    @CronapiMetaData(type="function", name="{{publishPostPageWithImage}}", nameTags={"Novo Post com Imagem", "Publicar", "New Post with Image", "Publish"}, description="{{publishPostPageWithImageDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var publishImageInPage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentPost}}") Var message, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{byteArray}}") Var binary) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        GraphResponse publishMessageResponse = (GraphResponse)pageClient.publish("me/photos", GraphResponse.class, BinaryAttachment.with((String)"image.png", (byte[])binary.getObjectAsByteArray(), (String)"image/png"), new Parameter[]{Parameter.with((String)"message", (Object)(message.getObjectAsString() + "\n"))});
        return new Var((Object)publishMessageResponse.getId());
    }

    @CronapiMetaData(type="function", name="{{publishPostPageWithVideo}}", nameTags={"Novo Post com Video", "Publicar", "New Post with Video", "Publish"}, description="{{publishPostPageWithVideoDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var publishVideoInPage(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{contentPost}}") Var message, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{byteArray}}") Var binary) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        GraphResponse publishMessageResponse = (GraphResponse)pageClient.publish("me/videos", GraphResponse.class, BinaryAttachment.with((String)"video.mp4", (byte[])binary.getObjectAsByteArray()), new Parameter[]{Parameter.with((String)"description", (Object)(message.getObjectAsString() + "\n"))});
        return new Var((Object)publishMessageResponse.getId());
    }

    @CronapiMetaData(type="function", name="{{deletePublishing}}", nameTags={"Apagar Post", "Apagar", "Delete Post", "Delete"}, description="{{deletePublishingDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var deleteObject(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{idPost}}") Var idPost) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        Boolean deleted = pageClient.deleteObject(idPost.getObjectAsString(), new Parameter[0]);
        return new Var((Object)deleted);
    }

    public static final Var listPosts(Var pageAccessToken, Var since, Var limit) {
        return FacebookPosts.listFeed(pageAccessToken, since, limit, null);
    }

    @CronapiMetaData(type="function", name="{{listPublication}}", nameTags={"Listar Publica\u00e7\u00f5es", "Listar", "List Publications", "List"}, description="{{listPublicationDescription}}", returnType=CronapiMetaData.ObjectType.LIST)
    public static final Var listFeed(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{period}}") Var since, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{amount}}") Var limit, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{extraParams}}") Var extraParams) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (!since.isEmptyOrNull().booleanValue()) {
            parameters.add(Parameter.with((String)"since", (Object)since.getObjectAsDateTime().getTime()));
        }
        if (!limit.isEmptyOrNull().booleanValue()) {
            parameters.add(Parameter.with((String)"limit", (Object)limit.getObjectAsInt()));
        }
        if (extraParams != null && Boolean.FALSE.equals(extraParams.isEmptyOrNull())) {
            Map params = extraParams.getObjectAsMap();
            params.forEach((key, value) -> parameters.add(Parameter.with((String)key, (Object)String.valueOf(value))));
        }
        Connection filteredFeed = pageClient.fetchConnection("me/feed", Post.class, parameters.toArray(new Parameter[0]));
        return new Var((Object)filteredFeed.getData());
    }

    @CronapiMetaData(type="function", name="{{amountLikesInPost}}", nameTags={"Quantidade de Likes", "Likes", "Amount Likes", "Amount"}, description="{{amountLikesInPostDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getAmountLikesInPost(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{idPost}}") Var idPost) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        Post post = (Post)pageClient.fetchObject(idPost.getObjectAsString(), Post.class, new Parameter[]{Parameter.with((String)"fields", (Object)"likes.limit(0).summary(true)")});
        return new Var((Object)post.getLikesCount());
    }

    @CronapiMetaData(type="function", name="{{amountCommentsInPost}}", nameTags={"Quantidade de Coment\u00e1rios", "Comment", "Amount Comments", "Amount"}, description="{{amountCommentsInPostDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getAmountCommentsInPost(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{idPost}}") Var idPost) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        Post post = (Post)pageClient.fetchObject(idPost.getObjectAsString(), Post.class, new Parameter[]{Parameter.with((String)"fields", (Object)"comments.limit(0).summary(true)")});
        return new Var((Object)post.getCommentsCount());
    }

    @CronapiMetaData(type="function", name="{{amountSharesInPost}}", nameTags={"Quantidade de Compartilhamentos", "Shares", "Amount Shares", "Amount"}, description="{{amountSharesInPostDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getAmountSharesInPost(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{idPost}}") Var idPost) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        Post post = (Post)pageClient.fetchObject(idPost.getObjectAsString(), Post.class, new Parameter[]{Parameter.with((String)"fields", (Object)"shares.limit(0).summary(true)")});
        return new Var((Object)post.getSharesCount());
    }

    @CronapiMetaData(type="function", name="{{commentsInPost}}", nameTags={"Consultar Coment\u00e1rios", "Comments", "Get Comments"}, description="{{commentsInPostDescription}}", returnType=CronapiMetaData.ObjectType.LIST)
    public static final Var getCommentsInPost(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{idPost}}") Var idPost, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{limit}}") Var limit) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        ArrayList<String> commentaries = new ArrayList<String>();
        Connection comments = pageClient.fetchConnection(idPost.getObjectAsString() + "/comments", Comment.class, new Parameter[]{Parameter.with((String)"limit", (Object)limit.getObjectAsInt())});
        for (List commentPage : comments) {
            for (Comment comment : commentPage) {
                commentaries.add(comment.getMessage());
            }
        }
        return new Var(commentaries);
    }

    @CronapiMetaData(type="function", name="{{getConversations}}", nameTags={"Mensagem", "Message", "Conversation", "Chat", "Messenger"}, description="{{getConversationsDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getConversations(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{extraParams}}") Var parameters) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        ArrayList<Parameter> paramsList = new ArrayList<Parameter>();
        if (parameters != null && Boolean.FALSE.equals(parameters.isEmptyOrNull())) {
            Map params = parameters.getObjectAsMap();
            params.forEach((key, value) -> paramsList.add(Parameter.with((String)key, (Object)String.valueOf(value))));
        }
        if (paramsList.isEmpty()) {
            paramsList.add(Parameter.with((String)"fields", (Object)"messages{message,from,created_time,id},participants,name,senders,subject,message_count"));
        }
        Connection conversations = pageClient.fetchConnection("me/conversations", Conversation.class, paramsList.toArray(new Parameter[0]));
        return new Var((Object)conversations);
    }

    @CronapiMetaData(type="function", name="{{postConversation}}", nameTags={"Mensagem", "Message", "Conversation", "Chat", "Messenger"}, description="{{postConversationDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var postConversation(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{userId}}") Var userId, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{message}}") Var message) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        Message text = new Message(message.getObjectAsString());
        IdMessageRecipient recipient = new IdMessageRecipient(userId.getObjectAsString());
        SendResponse resp = (SendResponse)pageClient.publish("me/messages", SendResponse.class, new Parameter[]{Parameter.with((String)"recipient", (Object)recipient), Parameter.with((String)"message", (Object)text)});
        return new Var((Object)resp);
    }

    @CronapiMetaData(type="function", name="{{getCurrentUser}}", nameTags={"User", "Me", "Usu\u00e1rio", "Current User", "Usu\u00e1rio Corrente"}, description="{{getCurrentUserDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getCurrentUser(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{extraParams}}") Var parameters) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        ArrayList paramsList = new ArrayList();
        if (parameters != null && Boolean.FALSE.equals(parameters.isEmptyOrNull())) {
            Map params = parameters.getObjectAsMap();
            params.forEach((key, value) -> paramsList.add(Parameter.with((String)key, (Object)String.valueOf(value))));
        }
        User user = (User)pageClient.fetchObject("me", User.class, paramsList.toArray(new Parameter[0]));
        return new Var((Object)user);
    }

    @CronapiMetaData(type="function", name="{{getCustomUser}}", nameTags={"User", "Me", "Usu\u00e1rio", "Custom User", "Usu\u00e1rio Customizado"}, description="{{getCustomUserDescription}}", returnType=CronapiMetaData.ObjectType.STRING)
    public static final Var getCustomUser(@ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{accessTokenPage}}") Var pageAccessToken, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{userId}}") Var userId, @ParamMetaData(type=CronapiMetaData.ObjectType.MAP, description="{{extraParams}}") Var parameters) {
        DefaultFacebookClient pageClient = new DefaultFacebookClient(pageAccessToken.getObjectAsString(), Version.LATEST);
        ArrayList paramsList = new ArrayList();
        if (parameters != null && Boolean.FALSE.equals(parameters.isEmptyOrNull())) {
            Map params = parameters.getObjectAsMap();
            params.forEach((key, value) -> paramsList.add(Parameter.with((String)key, (Object)String.valueOf(value))));
        }
        User user = (User)pageClient.fetchObject(userId.getObjectAsString(), User.class, paramsList.toArray(new Parameter[0]));
        return new Var((Object)user);
    }
}

