package cronapi.plugin;

import cronapi.support.Constants;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.task.TaskQuery;

import java.util.HashMap;
import java.util.Map;

public class FilterPlugin extends AbstractProcessEnginePlugin {

    @Override
    public void postProcessEngineBuild(ProcessEngine processEngine) {
        FilterService filterService = processEngine.getFilterService();
        TaskService taskService = processEngine.getTaskService();

        FilterQuery filterQuery = filterService.createFilterQuery().filterName(Constants.FILTER_MY_TASKS);

        if (filterQuery.count() == 0) {
            Map<String, Object> filterProperties = new HashMap<>();
            filterProperties.put("description", "Tarefas atribuídas a mim");
            filterProperties.put("priority", -10);
            TaskQuery query = taskService.createTaskQuery().taskAssigneeExpression("${currentUser()}");
            Filter filter = filterService.newTaskFilter().setName(Constants.FILTER_MY_TASKS).setProperties(filterProperties).setQuery(query);
            filterService.saveFilter(filter);
        }

        filterQuery = filterService.createFilterQuery().filterName(Constants.FILTER_MY_GROUP_TASKS);

        if (filterQuery.count() == 0) {
            Map<String, Object> filterProperties = new HashMap<>();
            filterProperties.put("description", "Tarefas candidatas aos meus grupos");
            filterProperties.put("priority", -5);
            TaskQuery query = taskService.createTaskQuery().taskCandidateGroupInExpression("${currentUserGroups()}");
            Filter filter = filterService.newTaskFilter().setName(Constants.FILTER_MY_GROUP_TASKS).setProperties(filterProperties).setQuery(query);
            filterService.saveFilter(filter);
        }
    }
}