/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.bpm.identity.plugin.support.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.persistence.entity.GroupEntity;
import org.camunda.bpm.engine.impl.persistence.entity.UserEntity;

public class Utils {
    private static final String ADMIN_ROLE_NAME = "Administrators";

    public static List<User> transformUsers(List<cronapp.framework.api.User> userList) {
        return userList.stream().map(user -> {
            UserEntity userEntity = new UserEntity(user.getUsername());
            userEntity.setFirstName(user.getName());
            return userEntity;
        }).collect(Collectors.toList());
    }

    public static List<Group> transformGroups(Collection<String> groupList) {
        return groupList.stream().map(group -> {
            GroupEntity groupEntity = new GroupEntity(group);
            groupEntity.setName(group);
            groupEntity.setType(Utils.retrieveGroupType(group));
            return groupEntity;
        }).collect(Collectors.toList());
    }

    public static String getAdminRoleName() {
        return ADMIN_ROLE_NAME;
    }

    private static String retrieveGroupType(String group) {
        return StringUtils.equals((CharSequence)Utils.getAdminRoleName(), (CharSequence)group) ? "SYSTEM" : "WORKFLOW";
    }
}

