/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.bpm.identity.plugin.filter;

import cronapi.TokenUtils;
import io.cronapp.bpm.identity.plugin.logger.IdentityPluginLogger;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.util.EngineUtil;
import org.camunda.bpm.webapp.impl.security.auth.Authentication;
import org.camunda.bpm.webapp.impl.security.auth.AuthenticationService;
import org.camunda.bpm.webapp.impl.security.auth.Authentications;

public class CronAuthenticationTokenFilter
implements Filter {
    private static final IdentityPluginLogger LOG = IdentityPluginLogger.INSTANCE;
    private static final String ENGINE_NAME = "default";
    private AuthenticationService userAuthentications;

    public void init(FilterConfig filterConfig) {
        LOG.initServlet(this.getClass().getSimpleName());
        this.userAuthentications = new AuthenticationService();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String username;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String authToken = httpRequest.getHeader("X-AUTH-TOKEN");
        if (authToken == null || authToken.isBlank()) {
            authToken = TokenUtils.getTokenFromCookie((Cookie[])httpRequest.getCookies());
        }
        if ((username = TokenUtils.getUsernameFromToken((String)authToken)) != null && !TokenUtils.isTokenExpired((String)authToken)) {
            ProcessEngine processEngine = EngineUtil.lookupProcessEngine((String)ENGINE_NAME);
            Authentications authentications = this.createAuthentications(processEngine, username);
            Authentications.setCurrent((Authentications)authentications);
            Authentications.updateSession((HttpSession)httpRequest.getSession(), (Authentications)authentications);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        LOG.destroyServlet(this.getClass().getSimpleName());
    }

    private Authentications createAuthentications(ProcessEngine processEngine, String username) {
        Authentications authentications = new Authentications();
        Authentication authentication = this.userAuthentications.createAuthenticate(processEngine, username, null, null);
        authentications.addAuthentication(authentication);
        return authentications;
    }
}

