/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.bpm.identity.plugin.filter;

import io.cronapp.bpm.identity.plugin.logger.IdentityPluginLogger;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.util.EngineUtil;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class CronRestAuthenticationFilter
implements Filter {
    private static final IdentityPluginLogger LOG = IdentityPluginLogger.INSTANCE;
    private static final String ENGINE_NAME = "default";

    public void init(FilterConfig filterConfig) {
        LOG.initServlet(this.getClass().getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ProcessEngine engine = EngineUtil.lookupProcessEngine((String)ENGINE_NAME);
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        String username = this.extractUsername(principal);
        try {
            engine.getIdentityService().setAuthentication(username, this.getUserGroups());
            chain.doFilter(request, response);
        }
        finally {
            this.clearAuthentication(engine);
        }
    }

    public void destroy() {
        LOG.destroyServlet(this.getClass().getSimpleName());
    }

    private String extractUsername(Object principal) {
        if (principal instanceof UserDetails) {
            return ((UserDetails)principal).getUsername();
        }
        return principal.toString();
    }

    private void clearAuthentication(ProcessEngine engine) {
        engine.getIdentityService().clearAuthentication();
    }

    private List<String> getUserGroups() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
    }
}

