/*
 * Decompiled with CFR 0.152.
 */
package io.cronapp.bpm.identity.plugin.support.service;

import cronapi.Var;
import cronapi.database.DataSource;
import cronapp.framework.api.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class UserService {
    private static final String ENTITY_FULL_NAME = "app.entity.User";

    private UserService() {
    }

    public static UserService getInstance() {
        return new UserService();
    }

    public List<User> listUsers() {
        try {
            DataSource dataSource = new DataSource(ENTITY_FULL_NAME);
            dataSource.filter(null, new Var[0]);
            Var userResult = Var.valueOf((Object)dataSource.getPage().getContent());
            ArrayList<User> users = new ArrayList<User>();
            if (userResult.getType() == Var.Type.LIST) {
                for (Object user : userResult.getObjectAsList()) {
                    Var resultObject = Var.valueOf(user);
                    if (resultObject == null) continue;
                    Var name = resultObject.getField("name");
                    Var username = resultObject.getField("login");
                    if (name == null || name.getObject() == null || name.getObjectAsString().isEmpty()) {
                        name = username;
                    }
                    users.add(new User(name.getObjectAsString(), username.getObjectAsString()));
                }
            }
            return users;
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
    }
}

