/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.auditlog;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.QueryManager;
import cronapi.Var;
import cronapi.dateTime.Operations;
import cronapp.framework.scheduler.SchedulerHelper;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class AuditLogCleanUpJob
implements Job {
    private static final String QUERY_ADITLOG_CLEANUP = "auditlogcleanup";
    private static final String PARAM_ADITLOG_DAYS_CLEANUP = "saveAuditLog";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JsonObject queryAuditLogCleanUp = QueryManager.getQuery((String)QUERY_ADITLOG_CLEANUP);
        JsonObject appConfig = AppConfig.getJSON();
        JsonElement auditLogDaysCleanUp = appConfig.get(PARAM_ADITLOG_DAYS_CLEANUP);
        if (auditLogDaysCleanUp != null && queryAuditLogCleanUp.has("entityFullName") && queryAuditLogCleanUp.has("query")) {
            JsonObject query = (JsonObject)queryAuditLogCleanUp.get("query");
            try {
                cronapi.database.Operations.beginTransaction((Var)Var.valueOf((Object)queryAuditLogCleanUp.get("entityFullName")));
                cronapi.database.Operations.execute((Var)Var.valueOf((Object)queryAuditLogCleanUp.get("entityFullName")), (Var)Var.valueOf((Object)query.get("sqlContent")), (Var[])new Var[]{Var.valueOf((String)"date", (Object)Operations.incDay((Var)Operations.getNow(), (Var)Var.valueOf((Object)(auditLogDaysCleanUp.getAsInt() * -1))))});
                cronapi.database.Operations.commitTransaction((Var)Var.valueOf((Object)queryAuditLogCleanUp.get("entityFullName")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.info("Execute - " + Operations.getNow());
            this.logger.info("Params  - entityFullName - " + queryAuditLogCleanUp.get("entityFullName"));
            this.logger.info("Params  - sqlContent - " + query.get("sqlContent"));
            this.logger.info("Params  - saveAuditLog - " + auditLogDaysCleanUp.getAsInt());
            this.logger.info("Params  - date - " + Operations.incDay((Var)Operations.getNow(), (Var)Var.valueOf((Object)(auditLogDaysCleanUp.getAsInt() * -1))));
        }
    }

    @Bean(name={"auditLogCleanUpJobDetail"})
    public JobDetailFactoryBean auditLogCleanUpJobDetail() {
        return SchedulerHelper.createJobDetail(this.getClass());
    }

    @Bean(name={"auditLogCleanUpJobTrigger"})
    public CronTriggerFactoryBean auditLogCleanUpJobTrigger(@Qualifier(value="auditLogCleanUpJobDetail") JobDetail jobDetail) {
        return SchedulerHelper.createCronTrigger((JobDetail)jobDetail, (String)"0 0 * ? * *");
    }
}

