/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.social;

import cronapi.util.Operations;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.social.SocialConnectionSignup;
import cronapp.framework.authentication.social.SocialSignInAdapter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.social.UserIdSource;
import org.springframework.social.config.annotation.ConnectionFactoryConfigurer;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurer;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.mem.InMemoryUsersConnectionRepository;
import org.springframework.social.connect.web.ProviderSignInController;
import org.springframework.social.connect.web.SessionUserIdSource;
import org.springframework.social.connect.web.SignInAdapter;
import org.springframework.social.facebook.connect.FacebookConnectionFactory;
import org.springframework.social.github.connect.GitHubConnectionFactory;
import org.springframework.social.google.connect.GoogleConnectionFactory;

@Configuration
@EnableSocial
public class SocialConfig
implements SocialConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(SocialConfig.class);
    private SocialSignInAdapter socialSignInAdapter;
    private SocialConnectionSignup socialConnectionSignup;
    private static Properties PROPERTIES = SocialConfig.loadProperties();

    public SocialConfig(@Nullable SocialSignInAdapter socialSignInAdapter, @Nullable SocialConnectionSignup socialConnectionSignup) {
        this.socialSignInAdapter = socialSignInAdapter;
        this.socialConnectionSignup = socialConnectionSignup;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties() {
        ClassLoader classLoader = EventsManager.class.getClassLoader();
        try (InputStream stream = classLoader.getResourceAsStream("social.properties");){
            Properties properties;
            try (InputStreamReader reader = new InputStreamReader(stream);){
                Properties properties2 = new Properties();
                properties2.load(reader);
                properties = properties2;
            }
            return properties;
        }
        catch (Exception e) {
            logger.error("The \"social.properties\" file could not be loaded.", (Throwable)e);
            return new Properties();
        }
    }

    public static Properties getProperties() {
        if (Operations.IS_DEBUG) {
            return SocialConfig.loadProperties();
        }
        return PROPERTIES;
    }

    public static boolean isEnabled(String key) {
        return "true".equals(SocialConfig.getProperties().getProperty(key));
    }

    public static boolean isAutoSignUp() {
        return "true".equals(SocialConfig.getProperties().getProperty("autoSignUp"));
    }

    public void addConnectionFactories(ConnectionFactoryConfigurer connectionFactoryConfigurer, Environment environment) {
        if (SocialConfig.isEnabled("facebook")) {
            try {
                connectionFactoryConfigurer.addConnectionFactory((ConnectionFactory)new FacebookConnectionFactory(SocialConfig.getProperties().getProperty("facebook.appId"), SocialConfig.getProperties().getProperty("facebook.appSecret")));
            }
            catch (Exception e) {
                logger.error("Could not build the FacebookConnectionFactory.", (Throwable)e);
            }
        }
        if (SocialConfig.isEnabled("github")) {
            try {
                connectionFactoryConfigurer.addConnectionFactory((ConnectionFactory)new GitHubConnectionFactory(SocialConfig.getProperties().getProperty("github.appId"), SocialConfig.getProperties().getProperty("github.appSecret")));
            }
            catch (Exception e) {
                logger.error("Could not build the GitHubConnectionFactory.", (Throwable)e);
            }
        }
        if (SocialConfig.isEnabled("google")) {
            try {
                connectionFactoryConfigurer.addConnectionFactory((ConnectionFactory)new GoogleConnectionFactory(SocialConfig.getProperties().getProperty("google.appId"), SocialConfig.getProperties().getProperty("google.appSecret")));
            }
            catch (Exception e) {
                logger.error("Could not build the GoogleConnectionFactory.", (Throwable)e);
            }
        }
    }

    public UserIdSource getUserIdSource() {
        return new SessionUserIdSource();
    }

    @Bean
    public ProviderSignInController providerSignInController(ConnectionFactoryLocator connectionFactoryLocator, UsersConnectionRepository usersConnectionRepository) {
        ((InMemoryUsersConnectionRepository)usersConnectionRepository).setConnectionSignUp((ConnectionSignUp)this.socialConnectionSignup);
        return new ProviderSignInController(connectionFactoryLocator, usersConnectionRepository, (SignInAdapter)this.socialSignInAdapter);
    }

    public UsersConnectionRepository getUsersConnectionRepository(ConnectionFactoryLocator connectionFactoryLocator) {
        return new InMemoryUsersConnectionRepository(connectionFactoryLocator);
    }
}

