/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.sso;

import cronapi.Var;
import cronapp.framework.api.ApiManager;
import cronapp.framework.api.EventsManager;
import cronapp.framework.authentication.AuthenticationUtil;
import cronapp.framework.authentication.security.CronappAnonymousAuthenticationFilter;
import cronapp.framework.authentication.security.Permission;
import cronapp.framework.authentication.sso.CustomPrincipalExtractor;
import cronapp.framework.authentication.sso.SsoSecurityConfigurer;
import cronapp.framework.authentication.token.AuthenticationTokenFilter;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.security.oauth2.OAuth2AutoConfiguration;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2SsoProperties;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.ResourceServerTokenServicesConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.config.annotation.web.configuration.OAuth2ClientConfiguration;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Configuration
@EnableOAuth2Client
@AutoConfigureBefore(value={OAuth2AutoConfiguration.class})
@EnableConfigurationProperties(value={OAuth2SsoProperties.class})
@Import(value={OAuth2ClientConfiguration.class, ResourceServerTokenServicesConfiguration.class})
public class AuthorizationConfigurer
extends WebSecurityConfigurerAdapter {
    @Autowired(required=false)
    private Permission permission;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private List<AccessDecisionVoter<? extends Object>> decisionVoters;
    @Value(value="${security.oauth2.client.customPrincipalKey:#{null}}")
    private String customPrincipalKey;
    @Value(value="${security.oauth2.client.logoutUri:#{null}}")
    private String logoutUri;

    @Bean
    public AuthenticationTokenFilter authenticationTokenFilterBean() throws Exception {
        AuthenticationTokenFilter authenticationTokenFilter = new AuthenticationTokenFilter();
        authenticationTokenFilter.setAuthenticationManager(super.authenticationManagerBean());
        return authenticationTokenFilter;
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        if (this.permission == null) {
            http.anonymous().authenticationFilter((AnonymousAuthenticationFilter)new CronappAnonymousAuthenticationFilter("anonymousAuthenticationFilterKey", "anonymousUser", ApiManager.getPublicAuthorities()));
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).denyAll().accessDecisionManager((AccessDecisionManager)new UnanimousBased(this.decisionVoters));
        } else {
            this.permission.loadSecurityPermission(http);
            AuthenticationUtil.loadStaticSecurity(http);
        }
        ((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint()).and()).logout().logoutSuccessHandler(this.logoutHandler()).deleteCookies(new String[]{"_u"}).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().cacheControl().disable().frameOptions().disable().httpStrictTransportSecurity().disable();
        new SsoSecurityConfigurer(this.applicationContext).configure(http);
        http.addFilterBefore((Filter)this.authenticationTokenFilterBean(), UsernamePasswordAuthenticationFilter.class);
    }

    @Bean
    public OAuth2RestTemplate oauth2RestTemplate(OAuth2ClientContext oauth2ClientContext, OAuth2ProtectedResourceDetails details) {
        return new OAuth2RestTemplate(details, oauth2ClientContext);
    }

    @Bean
    public PrincipalExtractor customPrincipalExtractor() {
        System.setProperty("security.oauth2.client.customPrincipalKey", (String)StringUtils.defaultIfBlank((CharSequence)this.customPrincipalKey, (CharSequence)""));
        return new CustomPrincipalExtractor();
    }

    private LogoutSuccessHandler logoutHandler() {
        return (request, response, authentication) -> {
            if (EventsManager.hasEvent("onLogout") && authentication != null && authentication.getName() != null) {
                EventsManager.executeEventOnTransaction("onLogout", Var.valueOf((String)"username", (Object)authentication.getName()));
            }
            String appBaseUrl = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request).replacePath(null).build().toUriString();
            this.logoutUri = StringUtils.isNotBlank((CharSequence)this.logoutUri) ? this.logoutUri.replace("${appURL}", appBaseUrl).replace("${appURLEncoded}", URLEncoder.encode(appBaseUrl, StandardCharsets.UTF_8)) : request.getContextPath() + "/index.html";
            if (request.getHeader("Accept") == null || !request.getHeader("Accept").contains("json")) {
                response.setStatus(200);
                response.sendRedirect(request.getContextPath() + "/index.html");
            } else {
                response.setContentType("application/json");
                String jsonString = new JSONObject().put("logoutUri", (Object)this.logoutUri).put("appBaseUrl", (Object)appBaseUrl).toString();
                response.getWriter().print(jsonString);
            }
        };
    }
}

