/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.persistence;

import java.util.regex.Pattern;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public final class PasswordEncoder {
    private final Pattern bcryptPattern = Pattern.compile("\\A\\$2a?\\$\\d\\d\\$[./0-9A-Za-z]{53}");
    private final BCryptPasswordEncoder bcryptEncoder = new BCryptPasswordEncoder();

    private PasswordEncoder() {
    }

    public boolean isEncoded(String s) {
        return this.bcryptPattern.matcher(s).matches();
    }

    public String encode(String rawPassword) {
        if (this.isEncoded(rawPassword)) {
            return rawPassword;
        }
        return this.bcryptEncoder.encode((CharSequence)rawPassword);
    }

    public boolean matches(String rawPassword, String encodedPassword) {
        return this.bcryptEncoder.matches((CharSequence)rawPassword, encodedPassword);
    }

    public static PasswordEncoder getPasswordEncoder() {
        return PasswordEncoderHolder.INSTANCE;
    }

    private static class PasswordEncoderHolder {
        private static final PasswordEncoder INSTANCE = new PasswordEncoder();

        private PasswordEncoderHolder() {
        }
    }
}

