/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.saml;

import cronapp.framework.api.ApiManager;
import cronapp.framework.authentication.AuthenticationUtil;
import cronapp.framework.authentication.security.CronappAnonymousAuthenticationFilter;
import cronapp.framework.authentication.security.CronappAuthenticationSuccessHandler;
import cronapp.framework.authentication.security.CronappLogoutSuccessHandler;
import cronapp.framework.authentication.security.CronappUnauthorizedHandler;
import cronapp.framework.authentication.security.Permission;
import cronapp.framework.authentication.token.AuthenticationTokenFilter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.UnanimousBased;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.saml.SAMLDiscovery;
import org.springframework.security.saml.SAMLEntryPoint;
import org.springframework.security.saml.SAMLLogoutFilter;
import org.springframework.security.saml.SAMLLogoutProcessingFilter;
import org.springframework.security.saml.SAMLProcessingFilter;
import org.springframework.security.saml.SAMLWebSSOHoKProcessingFilter;
import org.springframework.security.saml.metadata.MetadataDisplayFilter;
import org.springframework.security.saml.metadata.MetadataGenerator;
import org.springframework.security.saml.metadata.MetadataGeneratorFilter;
import org.springframework.security.saml.websso.WebSSOProfileOptions;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SamlAuthorizationConfigurer
extends WebSecurityConfigurerAdapter {
    private final Permission permission;
    private final List<AccessDecisionVoter<? extends Object>> decisionVoters;
    private final ApplicationContext applicationContext;
    private Boolean forceAuthN = false;
    @Autowired
    private CronappLogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    private CronappUnauthorizedHandler unauthorizedHandler;

    public SamlAuthorizationConfigurer(@Nullable Permission permission, List<AccessDecisionVoter<? extends Object>> decisionVoters, ApplicationContext applicationContext) {
        this.permission = permission;
        this.decisionVoters = decisionVoters;
        this.applicationContext = applicationContext;
        this.forceAuthN = Boolean.valueOf(applicationContext.getEnvironment().getProperty("security.oauth2.saml.forceAuthN"));
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.applicationContext.getBean(SAMLEntryPoint.class));
        http.addFilterBefore((Filter)this.applicationContext.getBean(MetadataGeneratorFilter.class), ChannelProcessingFilter.class).addFilterAfter((Filter)this.applicationContext.getBean(FilterChainProxy.class), BasicAuthenticationFilter.class).addFilterAfter((Filter)this.applicationContext.getBean(AuthenticationTokenFilter.class), BasicAuthenticationFilter.class);
        if (this.permission == null) {
            http.anonymous().authenticationFilter((AnonymousAuthenticationFilter)new CronappAnonymousAuthenticationFilter("anonymousAuthenticationFilterKey", "anonymousUser", ApiManager.getPublicAuthorities()));
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().anyRequest()).denyAll().accessDecisionManager((AccessDecisionManager)new UnanimousBased(this.decisionVoters));
        } else {
            this.permission.loadSecurityPermission(http);
            AuthenticationUtil.loadStaticSecurity(http);
        }
        http.headers().cacheControl().disable().frameOptions().disable().httpStrictTransportSecurity().disable();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        ((HttpSecurity)((HttpSecurity)http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.unauthorizedHandler).and()).logout().logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    @Bean
    public FilterChainProxy samlFilter(SAMLLogoutFilter samlLogoutFilter, MetadataDisplayFilter metadataDisplayFilter, SAMLLogoutProcessingFilter samlLogoutProcessingFilter, SAMLProcessingFilter samlWebSSOProcessingFilter, SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter, SAMLDiscovery samlIDPDiscovery, SAMLEntryPoint samlEntryPoint) {
        ArrayList<DefaultSecurityFilterChain> chains = new ArrayList<DefaultSecurityFilterChain>();
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/login/**"), new Filter[]{samlEntryPoint}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/logout/**"), new Filter[]{samlLogoutFilter}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/metadata/**"), new Filter[]{metadataDisplayFilter}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSO/**"), new Filter[]{samlWebSSOProcessingFilter}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SSOHoK/**"), new Filter[]{samlWebSSOHoKProcessingFilter}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/SingleLogout/**"), new Filter[]{samlLogoutProcessingFilter}));
        chains.add(new DefaultSecurityFilterChain((RequestMatcher)new AntPathRequestMatcher("/saml/discovery/**"), new Filter[]{samlIDPDiscovery}));
        return new FilterChainProxy(chains);
    }

    @Bean
    public SAMLDiscovery samlIDPDiscovery() {
        return new SAMLDiscovery();
    }

    @Bean
    public SAMLLogoutProcessingFilter samlLogoutProcessingFilter(LogoutSuccessHandler successLogoutHandler, LogoutHandler logoutHandler) {
        return new SAMLLogoutProcessingFilter(successLogoutHandler, new LogoutHandler[]{logoutHandler});
    }

    @Bean
    public MetadataDisplayFilter metadataDisplayFilter() {
        return new MetadataDisplayFilter();
    }

    @Bean
    public SAMLProcessingFilter samlWebSSOProcessingFilter(AuthenticationManager authenticationManager, AuthenticationSuccessHandler successHandler, AuthenticationFailureHandler failureHandler) {
        SAMLProcessingFilter samlWebSSOProcessingFilter = new SAMLProcessingFilter();
        samlWebSSOProcessingFilter.setAuthenticationManager(authenticationManager);
        samlWebSSOProcessingFilter.setAuthenticationSuccessHandler(successHandler);
        samlWebSSOProcessingFilter.setAuthenticationFailureHandler(failureHandler);
        return samlWebSSOProcessingFilter;
    }

    @Bean
    public AuthenticationSuccessHandler successHandler() {
        return new CronappAuthenticationSuccessHandler();
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler authenticationFailureHandler() {
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setUseForward(true);
        failureHandler.setDefaultFailureUrl("/error");
        return failureHandler;
    }

    @Bean
    public SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter(AuthenticationManager authenticationManager, AuthenticationSuccessHandler successHandler, AuthenticationFailureHandler failureHandler) {
        SAMLWebSSOHoKProcessingFilter samlWebSSOHoKProcessingFilter = new SAMLWebSSOHoKProcessingFilter();
        samlWebSSOHoKProcessingFilter.setAuthenticationSuccessHandler(successHandler);
        samlWebSSOHoKProcessingFilter.setAuthenticationManager(authenticationManager);
        samlWebSSOHoKProcessingFilter.setAuthenticationFailureHandler(failureHandler);
        return samlWebSSOHoKProcessingFilter;
    }

    @Bean
    public SAMLLogoutFilter samlLogoutFilter(LogoutSuccessHandler successLogoutHandler, LogoutHandler logoutHandler) {
        return new SAMLLogoutFilter(successLogoutHandler, new LogoutHandler[]{logoutHandler}, new LogoutHandler[]{logoutHandler});
    }

    @Bean
    public SecurityContextLogoutHandler logoutHandler() {
        SecurityContextLogoutHandler logoutHandler = new SecurityContextLogoutHandler();
        logoutHandler.setInvalidateHttpSession(true);
        logoutHandler.setClearAuthentication(true);
        return logoutHandler;
    }

    @Bean
    public AuthenticationTokenFilter authenticationTokenFilter(AuthenticationManager authenticationManager) {
        AuthenticationTokenFilter authenticationTokenFilter = new AuthenticationTokenFilter();
        authenticationTokenFilter.setAuthenticationManager(authenticationManager);
        return authenticationTokenFilter;
    }

    @Bean
    public SAMLEntryPoint samlEntryPoint(WebSSOProfileOptions webSSOProfileOptions) {
        SAMLEntryPoint samlEntryPoint = new SAMLEntryPoint();
        samlEntryPoint.setDefaultProfileOptions(webSSOProfileOptions);
        return samlEntryPoint;
    }

    @Bean
    public WebSSOProfileOptions webSSOProfileOptions() {
        WebSSOProfileOptions webSSOProfileOptions = new WebSSOProfileOptions();
        webSSOProfileOptions.setIncludeScoping(Boolean.valueOf(false));
        webSSOProfileOptions.setForceAuthN(this.forceAuthN);
        return webSSOProfileOptions;
    }

    @Bean
    public MetadataGeneratorFilter metadataGeneratorFilter(MetadataGenerator metadataGenerator) {
        return new MetadataGeneratorFilter(metadataGenerator);
    }
}

